/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.validate;

import org.encog.EncogError;
import org.encog.ml.MLInput;
import org.encog.ml.MLMethod;
import org.encog.ml.MLOutput;
import org.encog.ml.data.MLDataSet;

public class ValidateNetwork {
    public static void validateMethodToData(MLMethod method, MLDataSet training) {
        if (!(method instanceof MLInput) || !(method instanceof MLOutput)) {
            throw new EncogError("This machine learning method is not compatible with the provided data.");
        }
        int trainingInputCount = training.getInputSize();
        int trainingOutputCount = training.getIdealSize();
        int methodInputCount = 0;
        int methodOutputCount = 0;
        if (method instanceof MLInput) {
            methodInputCount = ((MLInput)method).getInputCount();
        }
        if (method instanceof MLOutput) {
            methodOutputCount = ((MLOutput)method).getOutputCount();
        }
        if (methodInputCount != trainingInputCount) {
            throw new EncogError("The machine learning method has an input length of " + methodInputCount + ", but the training data has " + trainingInputCount + ". They must be the same.");
        }
        if (trainingOutputCount > 0 && methodOutputCount != trainingOutputCount) {
            throw new EncogError("The machine learning method has an output length of " + methodOutputCount + ", but the training data has " + trainingOutputCount + ". They must be the same.");
        }
    }
}

