/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.Serializer;
import ml.shifu.guagua.util.ReflectionUtils;

public class GZIPBytableSerializer<RESULT extends Bytable>
implements Serializer<RESULT> {
    @Override
    public byte[] objectToBytes(RESULT result) {
        ByteArrayOutputStream out = null;
        FilterOutputStream dataOut = null;
        try {
            out = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutput = new GZIPOutputStream(out);
            dataOut = new DataOutputStream(gzipOutput);
            result.write((DataOutput)((Object)dataOut));
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
        finally {
            if (dataOut != null) {
                try {
                    dataOut.close();
                }
                catch (IOException e) {
                    throw new GuaguaRuntimeException(e);
                }
            }
        }
        return out.toByteArray();
    }

    @Override
    public RESULT bytesToObject(byte[] data, String className) {
        if (data == null || className == null) {
            throw new NullPointerException(String.format("data and className should not be null. data:%s, className:%s", Arrays.toString(data), className));
        }
        Bytable result = (Bytable)ReflectionUtils.newInstance(className);
        FilterInputStream dataIn = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            GZIPInputStream gzipInput = new GZIPInputStream(in);
            dataIn = new DataInputStream(gzipInput);
            result.readFields((DataInput)((Object)dataIn));
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException(e);
        }
        finally {
            if (dataIn != null) {
                try {
                    dataIn.close();
                }
                catch (IOException e) {
                    throw new GuaguaRuntimeException(e);
                }
            }
        }
        return (RESULT)result;
    }
}

