/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaOptionsParser {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaOptionsParser.class);
    private static final String FILE_SEPERATOR = ",";
    private Configuration conf;
    private CommandLine commandLine;

    public GuaguaOptionsParser(Options opts, String[] args) throws IOException {
        this(new Configuration(), new Options(), args);
    }

    public GuaguaOptionsParser(String[] args) throws IOException {
        this(new Configuration(), new Options(), args);
    }

    public GuaguaOptionsParser(Configuration conf, String[] args) throws IOException {
        this(conf, new Options(), args);
    }

    public GuaguaOptionsParser(Configuration conf, Options options, String[] args) throws IOException {
        this.parseGeneralOptions(options, conf, args);
        this.conf = conf;
    }

    public String[] getRemainingArgs() {
        return this.commandLine == null ? new String[]{} : this.commandLine.getArgs();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    private static Options buildGeneralOptions(Options opts) {
        OptionBuilder.withArgName((String)"local|namenode:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a namenode");
        Option fs = OptionBuilder.create((String)"fs");
        OptionBuilder.withArgName((String)"local|jobtracker:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a job tracker");
        Option jt = OptionBuilder.create((String)"jt");
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify an application configuration file");
        Option oconf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((char)'D');
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated jar files to include in the classpath.");
        Option libjars = OptionBuilder.create((String)"libjars");
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated files to be copied to the map reduce cluster");
        Option files = OptionBuilder.create((String)"files");
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma separated archives to be unarchived on the compute machines.");
        Option archives = OptionBuilder.create((String)"archives");
        OptionBuilder.withArgName((String)"tokensFile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"name of the file with the tokens");
        Option tokensFile = OptionBuilder.create((String)"tokenCacheFile");
        OptionBuilder.withArgName((String)"paths");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify input folder");
        Option input = OptionBuilder.create((String)"i");
        OptionBuilder.withArgName((String)"zkserverhost:port,zkserverhost:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify zookeeper servers");
        Option zk = OptionBuilder.create((String)"z");
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify worker class name");
        Option worker = OptionBuilder.create((String)"w");
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify master class name");
        Option master = OptionBuilder.create((String)"m");
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify master result class name");
        Option masterResult = OptionBuilder.create((String)"mr");
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify worker result class name");
        Option workerResult = OptionBuilder.create((String)"wr");
        OptionBuilder.withArgName((String)"1");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify iteration count");
        Option iteration = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"job name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify job name");
        Option name = OptionBuilder.create((String)"n");
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify input format class name");
        Option inputformat = OptionBuilder.create((String)"inputformat");
        opts.addOption(fs);
        opts.addOption(jt);
        opts.addOption(oconf);
        opts.addOption(property);
        opts.addOption(libjars);
        opts.addOption(files);
        opts.addOption(archives);
        opts.addOption(tokensFile);
        opts.addOption(input);
        opts.addOption(zk);
        opts.addOption(worker);
        opts.addOption(master);
        opts.addOption(masterResult);
        opts.addOption(workerResult);
        opts.addOption(iteration);
        opts.addOption(name);
        opts.addOption(inputformat);
        return opts;
    }

    private void processGeneralOptions(Configuration conf, CommandLine line) throws IOException {
        if (line.hasOption("fs")) {
            FileSystem.setDefaultUri((Configuration)conf, (String)line.getOptionValue("fs"));
        }
        if (line.hasOption("jt")) {
            conf.set("mapred.job.tracker", line.getOptionValue("jt"));
        }
        if (line.hasOption("conf")) {
            String[] values;
            for (String value : values = line.getOptionValues("conf")) {
                conf.addResource(new Path(value));
            }
        }
        if (line.hasOption("libjars")) {
            conf.set("tmpjars", this.validateFiles(line.getOptionValue("libjars"), conf));
            URL[] libjars = GuaguaOptionsParser.getLibJars(conf);
            if (libjars != null && libjars.length > 0) {
                conf.setClassLoader((ClassLoader)new URLClassLoader(libjars, conf.getClassLoader()));
                Thread.currentThread().setContextClassLoader(new URLClassLoader(libjars, Thread.currentThread().getContextClassLoader()));
            }
        }
        if (line.hasOption("files")) {
            conf.set("tmpfiles", this.validateFiles(line.getOptionValue("files"), conf));
        }
        if (line.hasOption("archives")) {
            conf.set("tmparchives", this.validateFiles(line.getOptionValue("archives"), conf));
        }
        if (line.hasOption('D')) {
            String[] property = line.getOptionValues('D');
            for (String prop : property) {
                String[] keyval = prop.split("=", 2);
                if (keyval.length != 2) continue;
                conf.set(keyval[0], keyval[1]);
            }
        }
        conf.setBoolean("mapred.used.genericoptionsparser", true);
        if (line.hasOption("tokenCacheFile")) {
            String fileName = line.getOptionValue("tokenCacheFile");
            try {
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
                Path p = new Path(fileName);
                if (!localFs.exists(p)) {
                    throw new FileNotFoundException("File " + fileName + " does not exist.");
                }
                LOG.debug("setting conf tokensFile: {}", (Object)fileName);
                conf.set("mapreduce.job.credentials.json", localFs.makeQualified(p).toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static URL[] getLibJars(Configuration conf) throws IOException {
        String jars = conf.get("tmpjars");
        if (jars == null) {
            return null;
        }
        String[] files = jars.split(FILE_SEPERATOR);
        ArrayList<URL> cp = new ArrayList<URL>();
        for (String file : files) {
            Path tmp = new Path(file);
            if (!tmp.getFileSystem(conf).equals(FileSystem.getLocal((Configuration)conf))) continue;
            cp.add(FileSystem.getLocal((Configuration)conf).pathToFile(tmp).toURI().toURL());
        }
        return cp.toArray(new URL[0]);
    }

    private String validateFiles(String files, Configuration conf) throws IOException {
        if (files == null) {
            return null;
        }
        String[] fileArr = files.split(FILE_SEPERATOR);
        String[] finalArr = new String[fileArr.length];
        for (int i = 0; i < fileArr.length; ++i) {
            String finalPath;
            URI pathURI;
            String tmp = fileArr[i];
            try {
                pathURI = new URI(tmp);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            Path path = new Path(pathURI);
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
            if (pathURI.getScheme() == null) {
                if (!localFs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified((FileSystem)localFs).toString();
            } else {
                FileSystem fs = path.getFileSystem(conf);
                if (!fs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(fs).toString();
            }
            finalArr[i] = finalPath;
        }
        return StringUtils.arrayToString((String[])finalArr);
    }

    private String[] parseGeneralOptions(Options opts, Configuration conf, String[] args) throws IOException {
        opts = GuaguaOptionsParser.buildGeneralOptions(opts);
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(opts, args, true);
            this.processGeneralOptions(conf, this.commandLine);
            return this.commandLine.getArgs();
        }
        catch (ParseException e) {
            LOG.warn("options parsing failed: {}", (Object)e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return args;
        }
    }

    public static void printGenericCommandUsage(PrintStream out) {
        out.println("Generic options supported are");
        out.println("-conf <configuration file>     specify an application configuration file");
        out.println("-D <property=value>            use value for given property");
        out.println("-fs <local|namenode:port>      specify a namenode");
        out.println("-jt <local|jobtracker:port>    specify a job tracker");
        out.println("-files <comma separated list of files>    specify comma separated files to be copied to the map reduce cluster");
        out.println("-libjars <comma separated list of jars>    specify comma separated jar files to include in the classpath.");
        out.println("-archives <comma separated list of archives>    specify comma separated archives to be unarchived on the compute machines.");
        out.println("-i <input folder or input file>    specify input folder or input file.");
        out.println("-z <comma separated list of zookeeper servers>    specify zookeeper servers.");
        out.println("-w <full qualified class name>    specify worker class name.");
        out.println("-m <full qualified class name>    specify master class name.");
        out.println("-mr <full qualified class name>    specify master result class name.");
        out.println("-wr <full qualified class name>    specify worker result class name.");
        out.println("-c <number>    specify maximal iteration count.");
        out.println("-n <job name>    specify job name.");
        out.println("-inputformat <inputformat class name>    specify inputformat class name.\n");
        out.println("The general command line syntax is");
        out.println("bin/hadoop command [genericOptions] [commandOptions]\n");
    }
}

