/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn;

import com.google.common.collect.Maps;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.coordinator.zk.ZooKeeperUtils;
import ml.shifu.guagua.hadoop.io.GuaguaInputSplit;
import ml.shifu.guagua.hadoop.io.GuaguaOptionsParser;
import ml.shifu.guagua.hadoop.io.GuaguaWritableSerializer;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.HaltBytable;
import ml.shifu.guagua.master.MasterComputable;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.worker.WorkerComputable;
import ml.shifu.guagua.yarn.GuaguaAppMaster;
import ml.shifu.guagua.yarn.util.GsonUtils;
import ml.shifu.guagua.yarn.util.InputSplitUtils;
import ml.shifu.guagua.yarn.util.YarnUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaYarnClient
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaYarnClient.class);
    private static final DecimalFormat DF;
    private static final int JOB_STATUS_INTERVAL_MSECS = 2000;
    private static String embededZooKeeperServer;
    private YarnClient yarnClient;
    private String amQueue = "default";
    private ApplicationId appId;
    private String appName;
    private int reportCounter;
    private long startTime;
    private List<InputSplit> inputSplits;

    public GuaguaYarnClient() {
        this((Configuration)new YarnConfiguration());
    }

    public GuaguaYarnClient(Configuration conf) {
        this.setConf(conf);
    }

    public static void addInputPath(Configuration conf, Path path) throws IOException {
        path = path.getFileSystem(conf).makeQualified(path);
        String dirStr = StringUtils.escapeString((String)path.toString());
        String dirs = conf.get("guagua.yarn.input.dir");
        conf.set("guagua.yarn.input.dir", dirs == null ? dirStr : dirs + "," + dirStr);
    }

    private static void printUsage() {
        GuaguaOptionsParser.printGenericCommandUsage(System.out);
        System.out.println("For detailed invalid parameter, please check:");
    }

    private static String findContainingJar(Class<?> my_class) {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void copyResourcesToFS() throws IOException {
        LOG.debug("Copying resources to filesystem");
        YarnUtils.exportGuaguaConfiguration(this.getConf(), this.getAppId());
        YarnUtils.copyLocalResourcesToFs(this.getConf(), this.getAppId());
        try {
            YarnUtils.copyLocalResourceToFs("log4j.properties", "log4j.properties", this.getConf(), this.getAppId());
        }
        catch (FileNotFoundException ex) {
            LOG.warn("log4j.properties file not found, you had better to provide a log4j.properties for yarn app.");
        }
    }

    private List<InputSplit> createNewSplits() throws IOException {
        List<Object> newSplits = null;
        boolean combinable = this.getConf().getBoolean("guagua.split.combinable", false);
        long blockSize = FileSystem.get((Configuration)this.getConf()).getDefaultBlockSize(null);
        long combineSize = this.getConf().getLong("guagua.split.maxCombinedSplitSize", blockSize);
        if (combineSize == 0L) {
            combineSize = blockSize;
        }
        if (combinable) {
            List<InputSplit> splits = InputSplitUtils.getFileSplits(this.getConf(), combineSize);
            LOG.info("combine size:{}, splits:{}", (Object)combineSize, splits);
            newSplits = InputSplitUtils.getFinalCombineGuaguaSplits(splits, combineSize);
        } else {
            newSplits = new ArrayList();
            for (InputSplit inputSplit : InputSplitUtils.getFileSplits(this.getConf(), combineSize)) {
                FileSplit fs = (FileSplit)inputSplit;
                newSplits.add((Object)new GuaguaInputSplit(false, new FileSplit[]{fs}));
            }
        }
        int masters = this.getConf().getInt("guagua.master.number", 1);
        for (int i = 0; i < masters; ++i) {
            newSplits.add((Object)new GuaguaInputSplit(true, (FileSplit)null));
        }
        int mapperSize = newSplits.size();
        LOG.info("inputs size including master: {}", (Object)mapperSize);
        LOG.debug("input splits: {}", newSplits);
        this.getConf().set("guagua.worker.number", mapperSize - masters + "");
        return newSplits;
    }

    private <T extends InputSplit> List<InputSplit> writeNewSplits(Path jobSubmitDir) throws IOException, InterruptedException {
        List<InputSplit> splits = this.createNewSplits();
        InputSplit[] array = splits.toArray(new InputSplit[splits.size()]);
        Arrays.sort(array, new SplitComparator());
        JobSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)this.getConf(), (FileSystem)jobSubmitDir.getFileSystem(this.getConf()), (InputSplit[])array);
        return splits;
    }

    private static GuaguaOptionsParser parseOpts(String[] args, Configuration conf) throws IOException, ClassNotFoundException {
        GuaguaOptionsParser parser = new GuaguaOptionsParser(conf, args);
        conf.set("guagua.yarn.app.lib.jar", conf.get("tmpjars"));
        String jar = GuaguaYarnClient.findContainingJar(Class.forName(conf.get("guagua.master.computable.class", GuaguaYarnClient.class.getName())));
        if (jar != null) {
            conf.set("guagua.yarn.app.jar", jar);
        }
        CommandLine cmdLine = parser.getCommandLine();
        GuaguaYarnClient.checkInputSetting(conf, cmdLine);
        GuaguaYarnClient.checkZkServerSetting(conf, cmdLine);
        GuaguaYarnClient.checkWorkerClassSetting(conf, cmdLine);
        GuaguaYarnClient.checkMasterClassName(conf, cmdLine);
        GuaguaYarnClient.checkIterationCountSetting(conf, cmdLine);
        GuaguaYarnClient.checkResultClassSetting(conf, cmdLine);
        GuaguaYarnClient.checkAppName(conf, cmdLine);
        return parser;
    }

    private static void checkAppName(Configuration conf, CommandLine cmdLine) {
        String name = "guagua";
        if (cmdLine.hasOption("-n")) {
            name = cmdLine.getOptionValue("n");
        }
        conf.set("guagua.yarn.app.name", name);
    }

    private static void checkResultClassSetting(Configuration conf, CommandLine cmdLine) {
        Class<?> workerResultClass;
        Class<?> masterResultClass;
        if (!cmdLine.hasOption("-mr")) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Master result class name should be provided by '-mr' parameter.");
        }
        String resultClassName = cmdLine.getOptionValue("mr").trim();
        try {
            masterResultClass = Class.forName(resultClassName);
        }
        catch (ClassNotFoundException e) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException(String.format("Master result class %s set by '-mr' can not be found in class path.", resultClassName), e);
        }
        if (Writable.class.isAssignableFrom(masterResultClass)) {
            conf.set("guagua.master.io.serializer", GuaguaWritableSerializer.class.getName());
            conf.set("guagua.master.result.class", resultClassName);
        } else if (Bytable.class.isAssignableFrom(masterResultClass)) {
            conf.set("guagua.master.result.class", resultClassName);
            if (!ReflectionUtils.hasEmptyParameterConstructor(masterResultClass)) {
                throw new IllegalArgumentException("Master result class should have default constuctor without any parameters.");
            }
        } else {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Master result class name provided by '-mr' parameter should implement 'com.paypal.guagua.io.Bytable' or 'org.apache.hadoop.io.Writable'.");
        }
        if (!cmdLine.hasOption("-wr")) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Worker result class name should be provided by '-wr' parameter.");
        }
        String resultClassName2 = cmdLine.getOptionValue("wr").trim();
        try {
            workerResultClass = Class.forName(resultClassName2);
        }
        catch (ClassNotFoundException e) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException(String.format("Worker result class %s set by '-wr' can not be found in class path.", resultClassName2), e);
        }
        if (Writable.class.isAssignableFrom(workerResultClass)) {
            conf.set("guagua.worker.io.serializer", GuaguaWritableSerializer.class.getName());
            conf.set("guagua.worker.result.class", resultClassName2);
        } else if (Bytable.class.isAssignableFrom(workerResultClass)) {
            conf.set("guagua.worker.result.class", resultClassName2);
            if (!ReflectionUtils.hasEmptyParameterConstructor(workerResultClass)) {
                throw new IllegalArgumentException("Worker result class should have default constuctor without any parameters.");
            }
        } else {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Worker result class name provided by '-wr' parameter should implement 'com.paypal.guagua.io.Bytable' or 'org.apache.hadoop.io.Writable'.");
        }
        if (HaltBytable.class.isAssignableFrom(masterResultClass) && !HaltBytable.class.isAssignableFrom(workerResultClass) || HaltBytable.class.isAssignableFrom(workerResultClass) && !HaltBytable.class.isAssignableFrom(masterResultClass)) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Worker and master result classes should both implementent HaltBytable.");
        }
    }

    private static void checkIterationCountSetting(Configuration conf, CommandLine cmdLine) {
        if (!cmdLine.hasOption("-c")) {
            System.err.println("WARN: Total iteration number is not set, default 50 will be used.");
            System.err.println("WARN: Total iteration number can be provided by '-c' parameter with non-empty value.");
            conf.setInt("guagua.iteration.count", 50);
        } else {
            int totalIteration = 0;
            try {
                totalIteration = Integer.parseInt(cmdLine.getOptionValue("c").trim());
            }
            catch (NumberFormatException e) {
                GuaguaYarnClient.printUsage();
                throw new IllegalArgumentException("Total iteration number set by '-c' should be a valid number.");
            }
            conf.setInt("guagua.iteration.count", totalIteration);
        }
    }

    private static void checkMasterClassName(Configuration conf, CommandLine cmdLine) throws ClassNotFoundException {
        Class<?> masterClass;
        if (!cmdLine.hasOption("-m")) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Master class name should be provided by '-m' parameter.");
        }
        String masterClassOptionValue = cmdLine.getOptionValue("m");
        if (masterClassOptionValue == null || masterClassOptionValue.length() == 0) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Master class name should be provided by '-m' parameter with non-empty value.");
        }
        try {
            masterClass = Class.forName(masterClassOptionValue.trim());
        }
        catch (ClassNotFoundException e) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException(String.format("The master class %s set by '-m' can not be found in class path.", masterClassOptionValue.trim()), e);
        }
        if (!MasterComputable.class.isAssignableFrom(masterClass)) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Master class name provided by '-m' should implement 'com.paypal.guagua.master.MasterComputable' interface.");
        }
        if (!ReflectionUtils.hasEmptyParameterConstructor(masterClass)) {
            throw new IllegalArgumentException("Master class should have default constuctor without any parameters.");
        }
        conf.set("guagua.master.computable.class", masterClassOptionValue.trim());
    }

    private static void checkWorkerClassSetting(Configuration conf, CommandLine cmdLine) {
        Class<?> workerClass;
        if (!cmdLine.hasOption("-w")) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Worker class name should be provided by '-w' parameter.");
        }
        String workerClassOptionValue = cmdLine.getOptionValue("w");
        if (workerClassOptionValue == null || workerClassOptionValue.length() == 0) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Worker class name should be provided by '-w' parameter with non-empty value.");
        }
        try {
            workerClass = Class.forName(workerClassOptionValue.trim());
        }
        catch (ClassNotFoundException e) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException(String.format("The worker class %s set by '-w' can not be found in class path.", workerClassOptionValue.trim()), e);
        }
        if (!WorkerComputable.class.isAssignableFrom(workerClass)) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Worker class name provided by '-w' should implement 'com.paypal.guagua.worker.WorkerComputable' interface.");
        }
        if (!ReflectionUtils.hasEmptyParameterConstructor(workerClass)) {
            throw new IllegalArgumentException("Worker class should have default constuctor without any parameters.");
        }
        conf.set("guagua.worker.computable.class", workerClassOptionValue.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkZkServerSetting(Configuration conf, CommandLine cmdLine) {
        if (!cmdLine.hasOption("-z")) {
            System.err.println("WARN: ZooKeeper server is not set, embeded ZooKeeper server will be started.");
            System.err.println("WARN: For big data guagua application, independent ZooKeeper instance is recommended.");
            System.err.println("WARN: Zookeeper servers can be provided by '-z' parameter with non-empty value.");
            boolean isZkInClient = conf.getBoolean("guagua.zk.embedbed.isInClient", true);
            if (isZkInClient) {
                Class<GuaguaYarnClient> clazz = GuaguaYarnClient.class;
                synchronized (GuaguaYarnClient.class) {
                    if (embededZooKeeperServer == null) {
                        int embedZkClientPort = 0;
                        try {
                            embedZkClientPort = ZooKeeperUtils.startEmbedZooKeeper();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        ZooKeeperUtils.checkIfEmbedZooKeeperStarted((int)embedZkClientPort);
                        try {
                            embededZooKeeperServer = InetAddress.getLocalHost().getHostName() + ":" + embedZkClientPort;
                        }
                        catch (UnknownHostException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    conf.set("guagua.zk.servers", embededZooKeeperServer);
                }
            } else {
                conf.set("guagua.master.system.intercepters", conf.get("guagua.master.system.intercepters", "ml.shifu.guagua.master.MasterTimer,ml.shifu.guagua.master.MemoryStatsMasterInterceptor,ml.shifu.guagua.hadoop.ZooKeeperMasterInterceptor,ml.shifu.guagua.master.NettyMasterCoordinator "));
                conf.set("guagua.worker.system.intercepters", conf.get("guagua.worker.system.intercepters", "ml.shifu.guagua.worker.WorkerTimer,ml.shifu.guagua.worker.MemoryStatsWorkerInterceptor,ml.shifu.guagua.hadoop.ZooKeeperWorkerInterceptor,ml.shifu.guagua.worker.NettyWorkerCoordinator"));
                System.err.println("WARN: Zookeeper server will be started in master node of cluster");
            }
            return;
        }
        String zkServers = cmdLine.getOptionValue("z");
        if (zkServers == null || zkServers.length() == 0) {
            throw new IllegalArgumentException("Zookeeper servers should be provided by '-z' parameter with non-empty value.");
        }
        if (!ZooKeeperUtils.checkServers((String)zkServers)) {
            throw new RuntimeException("Your specifed zookeeper instance is not alive, please check.");
        }
        conf.set("guagua.zk.servers", zkServers.trim());
    }

    private static void checkInputSetting(Configuration conf, CommandLine cmdLine) throws IOException {
        FileStatus fileStatus;
        if (!cmdLine.hasOption("-i")) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException("Input should be provided by '-i' parameter.");
        }
        String inputs = cmdLine.getOptionValue("i").trim();
        try {
            fileStatus = FileSystem.get((Configuration)conf).getFileStatus(new Path(inputs));
            LOG.info("Input files: {}", (Object)fileStatus);
        }
        catch (FileNotFoundException e) {
            GuaguaYarnClient.printUsage();
            throw new IllegalArgumentException(String.format("Input %s doesn't exist.", inputs), e);
        }
        GuaguaYarnClient.addInputPath(conf, fileStatus.getPath());
    }

    public int run(String[] args) throws Exception {
        LOG.info("Running Client");
        this.yarnClient.start();
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse getNewAppResponse = app.getNewApplicationResponse();
        this.checkPerNodeResourcesAvailable(getNewAppResponse);
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        this.setAppId(appContext.getApplicationId());
        LOG.info("Obtained new application ID: {}", (Object)this.getAppId());
        appContext.setApplicationId(this.getAppId());
        this.setAppName(this.getConf().get("guagua.yarn.app.name"));
        appContext.setApplicationName(this.getAppName());
        this.prepareInputSplits();
        this.copyResourcesToFS();
        appContext.setMaxAppAttempts(3);
        appContext.setQueue(this.getConf().get("guagua.yarn.queue.name", "default"));
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(this.getConf().getInt("guagua.yarn.master.memory", 1024));
        capability.setVirtualCores(this.getConf().getInt("guagua.yarn.master.vcores", 1));
        appContext.setResource(capability);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.getConf().getInt("guagua.yarn.master.priority", 0));
        appContext.setPriority(pri);
        ContainerLaunchContext containerContext = this.buildContainerLaunchContext();
        appContext.setAMContainerSpec(containerContext);
        try {
            LOG.info("Submitting application to ASM");
            this.setAppId(this.yarnClient.submitApplication(appContext));
            LOG.info("Got new appId after submission : {}", (Object)this.getAppId());
        }
        catch (YarnException yre) {
            LOG.info("Submitting application again to ASM");
            this.setAppId(this.yarnClient.submitApplication(appContext));
            LOG.info("Got new appId after submission : {}", (Object)this.getAppId());
        }
        LOG.info("GuaguaAppMaster container request was submitted to ResourceManager for job: {}", (Object)this.getAppName());
        return this.awaitYarnJobCompletion();
    }

    private int awaitYarnJobCompletion() throws YarnException, IOException {
        ApplicationReport report = null;
        try {
            boolean done;
            do {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ir) {
                    Thread.currentThread().interrupt();
                }
            } while (!(done = this.checkProgress(report = this.yarnClient.getApplicationReport(this.getAppId()))));
        }
        catch (IOException ex) {
            String diagnostics = null == report ? "" : "Diagnostics: " + report.getDiagnostics();
            LOG.error(String.format("Fatal fault encountered, failing %s. %s", this.getAppName(), diagnostics), (Throwable)ex);
            try {
                LOG.error("FORCIBLY KILLING Application from AppMaster.");
                this.yarnClient.killApplication(this.getAppId());
            }
            catch (YarnException yre) {
                LOG.error("Exception raised in attempt to kill application.", (Throwable)yre);
            }
            return -1;
        }
        return this.printFinalJobReport();
    }

    private boolean checkProgress(ApplicationReport report) {
        YarnApplicationState jobState = report.getYarnApplicationState();
        LOG.info("Got applicaton report for appId={}, state={}, progress={}%, amDiag={}, masterHost={}, masterRpcPort={}, queue={}, startTime={}, clientToken={}, finalState={}, trackingUrl={}, user={}", new Object[]{this.appId.getId(), report.getYarnApplicationState().toString(), DF.format(report.getProgress() * 100.0f), report.getDiagnostics(), report.getHost(), report.getRpcPort(), report.getQueue(), report.getStartTime(), report.getClientToAMToken(), report.getFinalApplicationStatus().toString(), report.getTrackingUrl(), report.getUser()});
        switch (jobState) {
            case FINISHED: {
                LOG.info("Application finished in {} ms", (Object)(System.currentTimeMillis() - this.getStartTime()));
                return true;
            }
            case KILLED: {
                LOG.error("{} reports KILLED state, diagnostics show: {}", (Object)this.getAppName(), (Object)report.getDiagnostics());
                return true;
            }
            case FAILED: {
                LOG.error("{} reports FAILED state, diagnostics show: {}", (Object)this.getAppName(), (Object)report.getDiagnostics());
                return true;
            }
        }
        if (this.reportCounter++ % 5 == 0) {
            this.displayJobReport(report);
        }
        return false;
    }

    private void displayJobReport(ApplicationReport report) {
        if (null == report) {
            throw new IllegalStateException(String.format("[*] Latest ApplicationReport for job %s was not received by the local client.", this.getAppName()));
        }
        float elapsed = (float)(System.currentTimeMillis() - report.getStartTime()) / 1000.0f;
        LOG.info("{}, Elapsed: {}", (Object)this.getAppName(), (Object)String.format("%.2f secs", Float.valueOf(elapsed)));
        LOG.info("{}, State: {} , Containers: used/reserved/needed-resources {}/{}/{}", new Object[]{report.getCurrentApplicationAttemptId(), report.getYarnApplicationState().name(), report.getApplicationResourceUsageReport().getNumUsedContainers(), report.getApplicationResourceUsageReport().getNumReservedContainers(), report.getApplicationResourceUsageReport().getNeededResources()});
    }

    private int printFinalJobReport() throws YarnException, IOException {
        try {
            ApplicationReport report = this.yarnClient.getApplicationReport(this.getAppId());
            FinalApplicationStatus finalAppStatus = report.getFinalApplicationStatus();
            long secs = (report.getFinishTime() - report.getStartTime()) / 1000L;
            String time = String.format("%d minutes, %d seconds.", secs / 60L, secs % 60L);
            LOG.info("Completed {}: {}, total running time: {}", new Object[]{this.getAppName(), finalAppStatus.name(), time});
            return finalAppStatus == FinalApplicationStatus.SUCCEEDED ? 0 : -1;
        }
        catch (YarnException yre) {
            LOG.error(String.format("Exception encountered while attempting to request a final job report for %s.", this.getAppId()), (Throwable)yre);
            return -1;
        }
    }

    private void prepareInputSplits() throws IOException, InterruptedException {
        this.inputSplits = this.writeNewSplits(YarnUtils.getAppDirectory(FileSystem.get((Configuration)this.getConf()), this.getAppId()));
        LOG.debug("Input split: {}", (Object)this.inputSplits.size());
        Collections.sort(this.inputSplits, new SplitComparator());
        int partition = 0;
        for (InputSplit inputSplit : this.inputSplits) {
            this.getConf().set("guagua.yarn.input.split." + ++partition, GsonUtils.toJson(inputSplit));
        }
        YarnUtils.exportGuaguaConfiguration(this.getConf(), this.getAppId());
        LOG.info("Input split size including master: {}", (Object)this.inputSplits.size());
    }

    public boolean init(String[] args) {
        try {
            this.yarnClient = YarnClient.createYarnClient();
            this.yarnClient.init(this.getConf());
        }
        catch (Throwable e) {
            LOG.error("Error in yarn client initiliazation.", e);
            return false;
        }
        return true;
    }

    private ContainerLaunchContext buildContainerLaunchContext() throws IOException {
        ContainerLaunchContext appMasterContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        appMasterContainer.setEnvironment(this.buildEnvironment());
        appMasterContainer.setLocalResources(this.buildLocalResourceMap());
        appMasterContainer.setCommands(this.buildAppMasterExecCommand());
        this.setToken(appMasterContainer);
        return appMasterContainer;
    }

    private List<String> buildAppMasterExecCommand() {
        String appMasterArgs = this.getConf().get("guagua.yarn.master.args");
        appMasterArgs = appMasterArgs == null ? "-server -XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70" : "-server -XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70 " + appMasterArgs;
        return YarnUtils.getCommand(GuaguaAppMaster.class.getName(), appMasterArgs, null, this.getConf().getInt("guagua.yarn.master.memory", 1024) + "");
    }

    private Map<String, String> buildEnvironment() {
        HashMap environment = Maps.newHashMap();
        LOG.info("Set the environment for the application master");
        YarnUtils.addLocalClasspathToEnv(environment, this.getConf());
        LOG.info("Environment for AM : {}", (Object)environment);
        return environment;
    }

    private Map<String, LocalResource> buildLocalResourceMap() throws IOException {
        return YarnUtils.getLocalResourceMap(this.getConf(), this.getAppId());
    }

    private void checkPerNodeResourcesAvailable(GetNewApplicationResponse cluster) throws YarnException, IOException {
        this.checkAndAdjustPerTaskHeapSize(cluster);
    }

    private void setToken(ContainerLaunchContext amContainer) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = new Credentials();
            String tokenRenewer = this.getConf().get("yarn.resourcemanager.principal");
            if (tokenRenewer == null || tokenRenewer.length() == 0) {
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
            if (tokens != null) {
                for (Token token : tokens) {
                    LOG.info("Got dt for " + fs.getUri() + "; " + token);
                }
            }
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            amContainer.setTokens(fsTokens);
        }
    }

    private void checkAndAdjustPerTaskHeapSize(GetNewApplicationResponse gnar) {
        int maxCapacity = gnar.getMaximumResourceCapability().getMemory();
        int guaguaYarnMem = this.getConf().getInt("guagua.child.memory", 1024);
        if (guaguaYarnMem > maxCapacity) {
            LOG.warn("Guagua's request of heap MB per-task is more than the minimum; downgrading guagua to {} MB.", (Object)maxCapacity);
            guaguaYarnMem = maxCapacity;
        }
        this.getConf().setInt("guagua.child.memory", guaguaYarnMem);
    }

    public ApplicationId getAppId() {
        return this.appId;
    }

    public void setAppId(ApplicationId appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAmQueue() {
        return this.amQueue;
    }

    public void setAmQueue(String amQueue) {
        this.amQueue = amQueue;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length == 1 && (args[0].equals("h") || args[0].equals("-h") || args[0].equals("-help") || args[0].equals("help"))) {
            GuaguaOptionsParser.printGenericCommandUsage(System.out);
            System.exit(0);
        }
        long startTime = System.currentTimeMillis();
        int result = 0;
        try {
            GuaguaYarnClient client = new GuaguaYarnClient();
            client.setStartTime(startTime);
            GuaguaOptionsParser parser = GuaguaYarnClient.parseOpts(args, client.getConf());
            LOG.info("Initializing client.");
            String[] remainingArgs = parser.getRemainingArgs();
            if (!client.init(remainingArgs)) {
                System.exit(-1);
            }
            result = client.run(remainingArgs);
        }
        catch (Throwable t) {
            LOG.error("Error running yarn client", t);
            System.exit(1);
        }
        if (result == 0) {
            LOG.info("Application completed successfully");
        } else {
            LOG.error("Application failed, please check the diagnosis info.");
        }
        System.exit(result);
    }

    static {
        Configuration.addDefaultResource((String)"guagua-site.xml");
        DF = (DecimalFormat)NumberFormat.getInstance();
        embededZooKeeperServer = null;
        DF.setMaximumFractionDigits(2);
        DF.setGroupingUsed(false);
    }

    private static class SplitComparator
    implements Comparator<InputSplit>,
    Serializable {
        private static final long serialVersionUID = 8176767139729612657L;

        private SplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                return len1 < len2 ? 1 : (len1 == len2 ? 0 : -1);
            }
            catch (IOException ie) {
                throw new GuaguaRuntimeException((Throwable)ie);
            }
            catch (InterruptedException ie) {
                throw new GuaguaRuntimeException((Throwable)ie);
            }
        }
    }
}

