package ml.sorus.mappings;

import java.util.ArrayList;
import java.util.List;

public class ClassMapping {

    private String[] data;

    private final List<MethodMapping> methodMappings = new ArrayList<>();
    private final List<FieldMapping> fieldMappings = new ArrayList<>();

    public ClassMapping addMethodMapping(MethodMapping methodMapping) {
        this.methodMappings.add(methodMapping);

        return this;
    }

    public MethodMapping getMethodMapping(int index, String name, String description) {
        for(MethodMapping methodMapping : this.methodMappings) {
            if(methodMapping.getName(index).equals(name) && methodMapping.getDescription(index).equals(description)) {
                return methodMapping;
            }
        }

        return null;
    }

    public List<MethodMapping> getMethodMappings() {
        return methodMappings;
    }

    public ClassMapping addFieldMapping(FieldMapping fieldMapping) {
        this.fieldMappings.add(fieldMapping);

        return this;
    }

    public FieldMapping getFieldMapping(int index, String name) {
        for(FieldMapping fieldMapping : this.fieldMappings) {
            if(fieldMapping.getName(index).equals(name)) {
                return fieldMapping;
            }
        }

        return null;
    }

    public List<FieldMapping> getFieldMappings() {
        return fieldMappings;
    }

    public ClassMapping setData(String... data) {
        this.data = data;
        return this;
    }

    public String getName(int index) {
        return this.data[index];
    }

    public String[] getData() {
        return this.data;
    }
}
