package ml.sorus.mappings;

public class MappingUtil {

    public static String getClassName(Mappings mappings, int inputIndex, int outputIndex, String name) {
        ClassMapping classMapping = mappings.getClassMapping(inputIndex, name);
        return classMapping.getName(outputIndex);
    }

    public static String getMethodName(Mappings mappings, int inputIndex, int outputIndex, String className, String methodName, String methodDescription) {
        ClassMapping classMapping = mappings.getClassMapping(inputIndex, className);
        MethodMapping methodMapping = classMapping.getMethodMapping(inputIndex, methodName, methodDescription);
        return methodMapping.getName(outputIndex);
    }

    public static String getMethodDescription(Mappings mappings, int inputIndex, int outputIndex, String className, String methodName, String methodDescription) {
        ClassMapping classMapping = mappings.getClassMapping(inputIndex, className);
        MethodMapping methodMapping = classMapping.getMethodMapping(inputIndex, methodName, methodDescription);
        return methodMapping.getDescription(outputIndex);
    }

    public static String getFieldName(Mappings mappings, int inputIndex, int outputIndex, String className, String fieldName) {
        ClassMapping classMapping = mappings.getClassMapping(inputIndex, className);
        FieldMapping fieldMapping = classMapping.getFieldMapping(inputIndex, fieldName);
        return fieldMapping.getName(outputIndex);
    }

}
