package ml.sorus.mappings;

import java.util.ArrayList;
import java.util.List;

public class Mappings {

    private final List<ClassMapping> classMappings = new ArrayList<>();

    public Mappings addClassMapping(ClassMapping classMapping) {
        this.classMappings.add(classMapping);

        return this;
    }

    public ClassMapping getClassMapping(int index, String name) {
        for(ClassMapping classMapping : this.classMappings) {
            if(classMapping.getName(index).equals(name)) {
                return classMapping;
            }
        }

        return null;
    }

    public List<ClassMapping> getClassMappings() {
        return classMappings;
    }

}
