package ml.sorus.mappings;

public class Pair<T, U> {

    public static <T, U> Pair<T, U> of(T key, U value) {
        return new Pair<>(key, value);
    }

    private final T key;
    private final U value;

    private Pair(T key, U value) {
        this.key = key;
        this.value = value;
    }

    public T getKey() {
        return key;
    }

    public U getValue() {
        return value;
    }
}
