/*
 * Decompiled with CFR 0.152.
 */
package ml.sorus.mappings;

import ml.sorus.mappings.ClassMapping;
import ml.sorus.mappings.FieldMapping;
import ml.sorus.mappings.Mappings;
import ml.sorus.mappings.MethodMapping;

public class MappingsParser {
    public static Mappings toMappings(String string) {
        Mappings mappings = new Mappings();
        String[] lines = string.split("\n");
        ClassMapping current = null;
        block5: for (String line : lines) {
            LineType lineType = MappingsParser.getLineType(line);
            switch (lineType) {
                case CLASS: {
                    if (current != null) {
                        mappings.addClassMapping(current);
                    }
                    String[] split = line.split(" ");
                    current = new ClassMapping().setData(split);
                    continue block5;
                }
                case FIELD: {
                    if (current == null) continue block5;
                    String[] split = line.substring(4).split(" ");
                    current.addFieldMapping(new FieldMapping().setData(split));
                    continue block5;
                }
                case METHOD: {
                    if (current == null) continue block5;
                    String[] split = line.substring(4).split(" ");
                    current.addMethodMapping(new MethodMapping().setData(split));
                }
            }
        }
        mappings.addClassMapping(current);
        return mappings;
    }

    private static LineType getLineType(String line) {
        return !line.startsWith("    ") ? LineType.CLASS : (line.contains("(") ? LineType.METHOD : LineType.FIELD);
    }

    public static String toString(Mappings mappings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ClassMapping classMapping : mappings.getClassMappings()) {
            stringBuilder.append(MappingsParser.format(classMapping.getData())).append("\n");
            for (FieldMapping fieldMapping : classMapping.getFieldMappings()) {
                stringBuilder.append("    ").append(MappingsParser.format(fieldMapping.getData())).append("\n");
            }
            for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
                stringBuilder.append("    ").append(MappingsParser.format(methodMapping.getData())).append("\n");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static String format(String[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : data) {
            stringBuilder.append(string).append(" ");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static enum LineType {
        CLASS,
        FIELD,
        METHOD;

    }
}

