/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.csp.cpower;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.csp.cpower.CPower;
import mn.foreman.api.endpoints.qse.prioritypower.PriorityPowerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPowerImpl
implements CPower {
    private static final Logger LOG = LoggerFactory.getLogger(PriorityPowerImpl.class);
    private final ObjectMapper objectMapper;
    private final String pickaxeId;
    private final WebUtil webUtil;

    public CPowerImpl(String pickaxeId, ObjectMapper objectMapper, WebUtil webUtil) {
        this.pickaxeId = pickaxeId;
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public Optional<Boolean> updateState(double sixSecondBasePoint, double fiveMinuteBasePoint, double realtimeLoad) {
        Boolean success = null;
        try {
            Optional<String> response = this.webUtil.post(String.format("/api/v2/csp/cpower/plc/%s/state", this.pickaxeId), this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"6SecBasePoint", (Object)sixSecondBasePoint, (Object)"5MinBasePoint", (Object)fiveMinuteBasePoint, (Object)"realtimeLoad", (Object)realtimeLoad)));
            success = response.isPresent();
        }
        catch (Exception e) {
            LOG.warn("Failed to update PLC state", (Throwable)e);
        }
        return Optional.ofNullable(success);
    }
}

