/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.model;

public class Network {
    public final String dns;
    public final String gateway;
    public final String hostname;
    public final String ipAddress;
    public final String netmask;

    Network(String dns, String gateway, String hostname, String ipAddress, String netmask) {
        this.dns = dns;
        this.gateway = gateway;
        this.hostname = hostname;
        this.ipAddress = ipAddress;
        this.netmask = netmask;
    }

    public static NetworkBuilder builder() {
        return new NetworkBuilder();
    }

    public String getDns() {
        return this.dns;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Network)) {
            return false;
        }
        Network other = (Network)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dns = this.getDns();
        String other$dns = other.getDns();
        if (this$dns == null ? other$dns != null : !this$dns.equals(other$dns)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$netmask = this.getNetmask();
        String other$netmask = other.getNetmask();
        return !(this$netmask == null ? other$netmask != null : !this$netmask.equals(other$netmask));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Network;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dns = this.getDns();
        result = result * 59 + ($dns == null ? 43 : $dns.hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $netmask = this.getNetmask();
        result = result * 59 + ($netmask == null ? 43 : $netmask.hashCode());
        return result;
    }

    public String toString() {
        return "Network(dns=" + this.getDns() + ", gateway=" + this.getGateway() + ", hostname=" + this.getHostname() + ", ipAddress=" + this.getIpAddress() + ", netmask=" + this.getNetmask() + ")";
    }

    public static class NetworkBuilder {
        private String dns;
        private String gateway;
        private String hostname;
        private String ipAddress;
        private String netmask;

        NetworkBuilder() {
        }

        public NetworkBuilder dns(String dns) {
            this.dns = dns;
            return this;
        }

        public NetworkBuilder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public NetworkBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public NetworkBuilder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public NetworkBuilder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Network build() {
            return new Network(this.dns, this.gateway, this.hostname, this.ipAddress, this.netmask);
        }

        public String toString() {
            return "Network.NetworkBuilder(dns=" + this.dns + ", gateway=" + this.gateway + ", hostname=" + this.hostname + ", ipAddress=" + this.ipAddress + ", netmask=" + this.netmask + ")";
        }
    }
}

