/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.notifications;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mn.foreman.api.JsonUtils;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.notifications.Notifications;

public class NotificationsImpl
implements Notifications {
    private final String clientId;
    private final ObjectMapper objectMapper;
    private final WebUtil webUtil;

    public NotificationsImpl(String clientId, ObjectMapper objectMapper, WebUtil webUtil) {
        this.clientId = clientId;
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public List<Notifications.Notification> discord(int sinceId, Instant sinceTimestamp) {
        return this.getNotifications(sinceId, sinceTimestamp, "discord");
    }

    @Override
    public List<Notifications.Notification> googleChat(int sinceId, Instant sinceTimestamp) {
        return this.getNotifications(sinceId, sinceTimestamp, "google-chat");
    }

    @Override
    public List<Notifications.Notification> slack(int sinceId, Instant sinceTimestamp) {
        return this.getNotifications(sinceId, sinceTimestamp, "slack");
    }

    @Override
    public List<Notifications.Notification> telegram(int sinceId, Instant sinceTimestamp) {
        return this.getNotifications(sinceId, sinceTimestamp, "telegram");
    }

    private List<Notifications.Notification> getNotifications(int sinceId, Instant sinceTimestamp, String destination) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (sinceId >= 0) {
            params.put("sinceId", Integer.toString(sinceId));
        }
        if (sinceTimestamp != null) {
            params.put("sinceTimestamp", Long.toString(sinceTimestamp.toEpochMilli()));
        }
        return this.webUtil.get(String.format("/api/notifications/%s/%s", destination, this.clientId), params).flatMap(response -> JsonUtils.fromJson(response, this.objectMapper, new TypeReference<List<Notifications.Notification>>(){})).orElse(Collections.emptyList());
    }
}

