/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mn.foreman.api.model.CommandDone;

public class CommandDoneBatch {
    @JsonProperty(value="commands")
    private final List<BatchedDone> commands;

    CommandDoneBatch(List<BatchedDone> commands) {
        this.commands = commands;
    }

    public static CommandDoneBatchBuilder builder() {
        return new CommandDoneBatchBuilder();
    }

    public List<BatchedDone> getCommands() {
        return this.commands;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandDoneBatch)) {
            return false;
        }
        CommandDoneBatch other = (CommandDoneBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BatchedDone> this$commands = this.getCommands();
        List<BatchedDone> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandDoneBatch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BatchedDone> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    public String toString() {
        return "CommandDoneBatch(commands=" + this.getCommands() + ")";
    }

    public static class CommandDoneBatchBuilder {
        private ArrayList<BatchedDone> commands;

        CommandDoneBatchBuilder() {
        }

        public CommandDoneBatchBuilder command(BatchedDone command) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.add(command);
            return this;
        }

        public CommandDoneBatchBuilder commands(Collection<? extends BatchedDone> commands) {
            if (commands == null) {
                throw new NullPointerException("commands cannot be null");
            }
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.addAll(commands);
            return this;
        }

        public CommandDoneBatchBuilder clearCommands() {
            if (this.commands != null) {
                this.commands.clear();
            }
            return this;
        }

        public CommandDoneBatch build() {
            List<BatchedDone> commands;
            switch (this.commands == null ? 0 : this.commands.size()) {
                case 0: {
                    commands = Collections.emptyList();
                    break;
                }
                case 1: {
                    commands = Collections.singletonList(this.commands.get(0));
                    break;
                }
                default: {
                    commands = Collections.unmodifiableList(new ArrayList<BatchedDone>(this.commands));
                }
            }
            return new CommandDoneBatch(commands);
        }

        public String toString() {
            return "CommandDoneBatch.CommandDoneBatchBuilder(commands=" + this.commands + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Response {
        @JsonProperty(value="success")
        public int success;
    }

    public static class BatchedDone {
        @JsonProperty(value="commandId")
        private final String commandId;
        @JsonProperty(value="done")
        private final CommandDone done;

        BatchedDone(String commandId, CommandDone done) {
            this.commandId = commandId;
            this.done = done;
        }

        public static BatchedDoneBuilder builder() {
            return new BatchedDoneBuilder();
        }

        public String getCommandId() {
            return this.commandId;
        }

        public CommandDone getDone() {
            return this.done;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchedDone)) {
                return false;
            }
            BatchedDone other = (BatchedDone)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$commandId = this.getCommandId();
            String other$commandId = other.getCommandId();
            if (this$commandId == null ? other$commandId != null : !this$commandId.equals(other$commandId)) {
                return false;
            }
            CommandDone this$done = this.getDone();
            CommandDone other$done = other.getDone();
            return !(this$done == null ? other$done != null : !((Object)this$done).equals(other$done));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchedDone;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $commandId = this.getCommandId();
            result = result * 59 + ($commandId == null ? 43 : $commandId.hashCode());
            CommandDone $done = this.getDone();
            result = result * 59 + ($done == null ? 43 : ((Object)$done).hashCode());
            return result;
        }

        public String toString() {
            return "CommandDoneBatch.BatchedDone(commandId=" + this.getCommandId() + ", done=" + this.getDone() + ")";
        }

        public static class BatchedDoneBuilder {
            private String commandId;
            private CommandDone done;

            BatchedDoneBuilder() {
            }

            @JsonProperty(value="commandId")
            public BatchedDoneBuilder commandId(String commandId) {
                this.commandId = commandId;
                return this;
            }

            @JsonProperty(value="done")
            public BatchedDoneBuilder done(CommandDone done) {
                this.done = done;
                return this;
            }

            public BatchedDone build() {
                return new BatchedDone(this.commandId, this.done);
            }

            public String toString() {
                return "CommandDoneBatch.BatchedDone.BatchedDoneBuilder(commandId=" + this.commandId + ", done=" + this.done + ")";
            }
        }
    }
}

