/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mn.foreman.api.model.CommandStart;

public class CommandStartBatch {
    @JsonProperty(value="commands")
    private final List<BatchedStart> commands;

    CommandStartBatch(List<BatchedStart> commands) {
        this.commands = commands;
    }

    public static CommandStartBatchBuilder builder() {
        return new CommandStartBatchBuilder();
    }

    public List<BatchedStart> getCommands() {
        return this.commands;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandStartBatch)) {
            return false;
        }
        CommandStartBatch other = (CommandStartBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BatchedStart> this$commands = this.getCommands();
        List<BatchedStart> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandStartBatch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BatchedStart> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    public String toString() {
        return "CommandStartBatch(commands=" + this.getCommands() + ")";
    }

    public static class CommandStartBatchBuilder {
        private ArrayList<BatchedStart> commands;

        CommandStartBatchBuilder() {
        }

        public CommandStartBatchBuilder command(BatchedStart command) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.add(command);
            return this;
        }

        public CommandStartBatchBuilder commands(Collection<? extends BatchedStart> commands) {
            if (commands == null) {
                throw new NullPointerException("commands cannot be null");
            }
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.addAll(commands);
            return this;
        }

        public CommandStartBatchBuilder clearCommands() {
            if (this.commands != null) {
                this.commands.clear();
            }
            return this;
        }

        public CommandStartBatch build() {
            List<BatchedStart> commands;
            switch (this.commands == null ? 0 : this.commands.size()) {
                case 0: {
                    commands = Collections.emptyList();
                    break;
                }
                case 1: {
                    commands = Collections.singletonList(this.commands.get(0));
                    break;
                }
                default: {
                    commands = Collections.unmodifiableList(new ArrayList<BatchedStart>(this.commands));
                }
            }
            return new CommandStartBatch(commands);
        }

        public String toString() {
            return "CommandStartBatch.CommandStartBatchBuilder(commands=" + this.commands + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Response {
        @JsonProperty(value="success")
        public int success;
    }

    public static class BatchedStart {
        @JsonProperty(value="commandId")
        private final String commandId;
        @JsonProperty(value="start")
        private final CommandStart start;

        BatchedStart(String commandId, CommandStart start) {
            this.commandId = commandId;
            this.start = start;
        }

        public static BatchedStartBuilder builder() {
            return new BatchedStartBuilder();
        }

        public String getCommandId() {
            return this.commandId;
        }

        public CommandStart getStart() {
            return this.start;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchedStart)) {
                return false;
            }
            BatchedStart other = (BatchedStart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$commandId = this.getCommandId();
            String other$commandId = other.getCommandId();
            if (this$commandId == null ? other$commandId != null : !this$commandId.equals(other$commandId)) {
                return false;
            }
            CommandStart this$start = this.getStart();
            CommandStart other$start = other.getStart();
            return !(this$start == null ? other$start != null : !this$start.equals(other$start));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchedStart;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $commandId = this.getCommandId();
            result = result * 59 + ($commandId == null ? 43 : $commandId.hashCode());
            CommandStart $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            return result;
        }

        public String toString() {
            return "CommandStartBatch.BatchedStart(commandId=" + this.getCommandId() + ", start=" + this.getStart() + ")";
        }

        public static class BatchedStartBuilder {
            private String commandId;
            private CommandStart start;

            BatchedStartBuilder() {
            }

            @JsonProperty(value="commandId")
            public BatchedStartBuilder commandId(String commandId) {
                this.commandId = commandId;
                return this;
            }

            @JsonProperty(value="start")
            public BatchedStartBuilder start(CommandStart start) {
                this.start = start;
                return this;
            }

            public BatchedStart build() {
                return new BatchedStart(this.commandId, this.start);
            }

            public String toString() {
                return "CommandStartBatch.BatchedStart.BatchedStartBuilder(commandId=" + this.commandId + ", start=" + this.start + ")";
            }
        }
    }
}

