/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum InfrastructureType {
    ANTSPACE_COOLING_TOWER("bitmain-liquid-cooling-tower"),
    GENERIC_SNMP("generic-snmp"),
    FORTINET_SWITCH("fortinet-switch"),
    MOONSHOT_PDU("moonshot-pdu"),
    OIT_PDU("oit-pdu"),
    TRILOGY_PDU("trilogy-pdu"),
    MANAGED_SWITCH("managed-switch"),
    CPOWER("cpower"),
    GENERIC_MODBUS("generic-modbus"),
    NU_ENERGEN("nuenergen"),
    GRID_BEYOND("grid-beyond");

    private static final Map<String, InfrastructureType> MAPPINGS;
    private final String type;

    private InfrastructureType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static InfrastructureType forValue(String value) {
        return MAPPINGS.get(value);
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    static {
        MAPPINGS = new ConcurrentHashMap<String, InfrastructureType>();
        for (InfrastructureType type : InfrastructureType.values()) {
            MAPPINGS.put(type.getType(), type);
        }
    }
}

