/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ApiType {
    BMINER_API(1),
    CASTXMR_API(2),
    CCMINER_API(3),
    DSTM_API(4),
    ETHMINER_API(5),
    EWBF_API(6),
    EXCAVATOR_API(7),
    JCEMINER_API(8),
    LOLMINER_API(9),
    SGMINER_API(10),
    SRBMINER_API(11),
    TREX_API(12),
    XMRIG_API(13),
    XMRSTAK_GPU_API(14),
    CLAYMORE_ETH_API(15),
    CLAYMORE_ZEC_API(16),
    ANTMINER_HS_API(17),
    ANTMINER_MHS_API(18),
    ANTMINER_GHS_API(19),
    ANTMINER_KHS_API(20),
    BAIKAL_API(21),
    DRAGONMINT_API(22),
    INNOSILICON_HS_API(23),
    INNOSILICON_KHS_API(24),
    INNOSILICON_MHS_API(25),
    INNOSILICON_GHS_API(26),
    DAYUN_API(27),
    WHATSMINER_API(28),
    AVALON_API(29),
    GMINER_API(30),
    MKXMINER_API(31),
    BLACKMINER_API(32),
    RHMINER_API(33),
    MULTIMINER_API(34),
    HSPMINER_API(35),
    NANOMINER_API(36),
    NICEHASH_API(37),
    OPTIMINER_API(38),
    GRINPRO_API(39),
    AUTOMINER_API(40),
    SPONDOOLIES_API(41),
    NBMINER_API(42),
    MINIZ_API(43),
    FUTUREBIT_API(44),
    SWARM_API(45),
    XMRSTAK_CPU_API(46),
    CPUMINER_API(47),
    IXIMINER_API(48),
    AIXIN_API(49),
    HYPERBIT_API(50),
    OBELISK_API(51),
    STRONGU_API(52),
    MULTMINER_API(53),
    MINERVA_API(54),
    OPENMINER_API(55),
    EPIC_API(56),
    GOLDSHELL_API(57),
    EBANG_API(58),
    IBELINK_API(59),
    TEAMBLACKMINER(60),
    CHEETAHMINER(61),
    JASMINER(62),
    HORIZON(63),
    ENIGMA(64),
    ALADDIN(65),
    KOI(66),
    HAMMER(67),
    BLOCKMINER(68),
    BITFURY(69),
    AURADINE(70),
    ICERIVER(71),
    IPOLLO(72),
    DESIWEMINER(73),
    WINDRIVER(74),
    ELPHAPEX(75);

    private static final Map<Integer, ApiType> MAPPINGS;
    private final int type;

    private ApiType(int type) {
        this.type = type;
    }

    @JsonCreator
    public static ApiType forValue(int value) {
        return MAPPINGS.get(value);
    }

    @JsonValue
    public int getType() {
        return this.type;
    }

    static {
        MAPPINGS = new ConcurrentHashMap<Integer, ApiType>();
        for (ApiType apiType : ApiType.values()) {
            MAPPINGS.put(apiType.getType(), apiType);
        }
    }
}

