/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.pickaxe;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mn.foreman.api.endpoints.miners.Miners;
import mn.foreman.api.model.ApiType;
import mn.foreman.api.model.CommandDone;
import mn.foreman.api.model.CommandDoneBatch;
import mn.foreman.api.model.CommandStart;
import mn.foreman.api.model.CommandStartBatch;
import mn.foreman.api.model.CommandUpdate;
import mn.foreman.api.model.CommandUpdateBatch;
import mn.foreman.api.model.Commands;
import mn.foreman.api.model.InfrastructureType;

public interface Pickaxe {
    public List<PickaxeInstance> all();

    public Optional<List<String>> cancelCommands();

    public Optional<CommandDone.Response> commandDone(CommandDone var1, String var2);

    public Optional<CommandDoneBatch.Response> commandDoneBatch(CommandDoneBatch var1);

    public Optional<CommandStart.Response> commandStarted(CommandStart var1);

    public Optional<CommandStartBatch.Response> commandStartedBatch(CommandStartBatch var1);

    public Optional<CommandUpdate.Response> commandUpdate(CommandUpdate var1, String var2);

    public Optional<CommandUpdateBatch.Response> commandUpdateBatch(CommandUpdateBatch var1);

    public Optional<PickaxeConfiguration> config();

    public Optional<Commands> getCommands();

    public Optional<List<InfrastructureConfig>> infrastructureConfigs();

    public boolean infrastructureUpdate(List<InfrastructureStats> var1);

    public Optional<List<MinerConfig>> minerConfigs(String var1, String var2, String var3);

    public boolean started();

    public boolean updateMacs(Map<Miners.Miner, String> var1);

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PickaxeInstance {
        @JsonProperty(value="id")
        public int id;
        @JsonProperty(value="key")
        public String key;
        @JsonProperty(value="label")
        public String label;
        @JsonProperty(value="version")
        public String version;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PickaxeConfiguration {
        @JsonProperty(value="collectDelay")
        public int collectDelay;
        @JsonProperty(value="collectDelayUnits")
        public String collectDelayUnits;
        @JsonProperty(value="commandCompletionBatchSize")
        public int commandCompletionBatchSize;
        @JsonProperty(value="commandQueryDelay")
        public int commandQueryDelay;
        @JsonProperty(value="commandQueryDelayUnits")
        public String commandQueryDelayUnits;
        @JsonProperty(value="commandThreadsOverride")
        public Integer commandThreadsOverride;
        @JsonProperty(value="compressMetrics")
        public boolean compressMetrics;
        @JsonProperty(value="cpowerPlcEnabled")
        public boolean cpowerPlcEnabled;
        @JsonProperty(value="cpowerPlcIp")
        public String cpowerPlcIp;
        @JsonProperty(value="cpowerPlcPassword")
        public String cpowerPlcPassword;
        @JsonProperty(value="cpowerPlcPort")
        public int cpowerPlcPort;
        @JsonProperty(value="cpowerPlcUsername")
        public String cpowerPlcUsername;
        @JsonProperty(value="infrastructureCollectDelay")
        public int infrastructureCollectDelay;
        @JsonProperty(value="infrastructureCollectDelayUnits")
        public String infrastructureCollectDelayUnits;
        @JsonProperty(value="infrastructureMetricsBatchSize")
        public Integer infrastructureMetricsBatchSize;
        @JsonProperty(value="infrastructureMetricsPushDelay")
        public int infrastructureMetricsPushDelay;
        @JsonProperty(value="infrastructureMetricsPushDelayUnits")
        public String infrastructureMetricsPushDelayUnits;
        @JsonProperty(value="infrastructureMetricsThreadsOverride")
        public Integer infrastructureMetricsThreadsOverride;
        @JsonProperty(value="infrastructureThreadsOverride")
        public Integer infrastructureThreadsOverride;
        @JsonProperty(value="jvmArguments")
        public String jvmArguments;
        @JsonProperty(value="metricsBatchSize")
        public Integer metricsBatchSize;
        @JsonProperty(value="metricsPushDelay")
        public int metricsPushDelay;
        @JsonProperty(value="metricsPushDelayUnits")
        public String metricsPushDelayUnits;
        @JsonProperty(value="metricsRateLimit")
        public Integer metricsRateLimit;
        @JsonProperty(value="metricsThreadsOverride")
        public Integer metricsThreadsOverride;
        @JsonProperty(value="priorityPowerRtacEnabled")
        public boolean priorityEnabled;
        @JsonProperty(value="priorityPowerRtacLocalAddress")
        public int priorityRtacClientAddress;
        @JsonProperty(value="priorityPowerRtacIp")
        public String priorityRtacIp;
        @JsonProperty(value="priorityPowerRtacPort")
        public int priorityRtacPort;
        @JsonProperty(value="priorityPowerRtacRemoteAddress")
        public int priorityRtacServerAddress;
        @JsonProperty(value="rangesRateLimit")
        public Integer rangesRateLimit;
        @JsonProperty(value="rangesScannerThreadsOverride")
        public Integer rangesScannerThreadsOverride;
        @JsonProperty(value="rangesTargetedRateLimit")
        public Integer rangesTargetedRateLimit;
        @JsonProperty(value="readSocketTimeout")
        public int readSocketTimeout;
        @JsonProperty(value="readSocketTimeoutUnits")
        public String readSocketTimeoutUnits;
        @JsonProperty(value="startStopRateLimit")
        public Integer startStopRateLimit;
        @JsonProperty(value="startStopScannerThreadsOverride")
        public Integer startStopScannerThreadsOverride;
        @JsonProperty(value="startStopTargetedRateLimit")
        public Integer startStopTargetedRateLimit;
        @JsonProperty(value="statsThreadsOverride")
        public Integer statsThreadsOverride;
        @JsonProperty(value="targetedRangesScannerThreadsOverride")
        public Integer targetedRangesScannerThreadsOverride;
        @JsonProperty(value="targetedStartStopScannerThreadsOverride")
        public Integer targetedStartStopScannerThreadsOverride;
        @JsonProperty(value="writeSocketTimeout")
        public int writeSocketTimeout;
        @JsonProperty(value="writeSocketTimeoutUnits")
        public String writeSocketTimeoutUnits;
        @JsonProperty(value="featureFlags")
        public Map<String, String> featureFlags;
        @JsonProperty(value="commandFinishingThreadsOverride")
        public Integer commandFinishingThreadsOverride;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MinerConfig {
        @JsonProperty(value="apiIp")
        public String apiIp;
        @JsonProperty(value="apiPort")
        public int apiPort;
        @JsonProperty(value="apiType")
        public ApiType apiType;
        @JsonProperty(value="cacheStats")
        public Boolean cacheStats;
        @JsonProperty(value="chisel")
        public ChiselConfig chisel;
        @JsonProperty(value="ignoredAttributes")
        public List<String> ignoredAttributes;
        @JsonProperty(value="params")
        public List<Param> params;

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Param {
            @JsonProperty(value="key")
            public String key;
            @JsonProperty(value="value")
            public Object value;

            public String toString() {
                return String.format("%s [ key=%s, value=%s ]", this.getClass().getSimpleName(), this.key, this.value);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ChiselConfig {
            @JsonProperty(value="apiPort")
            public int apiPort;

            public String toString() {
                return String.format("%s [ apiPort=%d ]", this.getClass().getSimpleName(), this.apiPort);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class InfrastructureStats {
        @JsonProperty(value="id")
        private final int id;
        private final Map<String, Object> stats;

        InfrastructureStats(int id, Map<String, Object> stats) {
            this.id = id;
            this.stats = stats;
        }

        public static InfrastructureStatsBuilder builder() {
            return new InfrastructureStatsBuilder();
        }

        public int getId() {
            return this.id;
        }

        public Map<String, Object> getStats() {
            return this.stats;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InfrastructureStats)) {
                return false;
            }
            InfrastructureStats other = (InfrastructureStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            Map<String, Object> this$stats = this.getStats();
            Map<String, Object> other$stats = other.getStats();
            return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InfrastructureStats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            Map<String, Object> $stats = this.getStats();
            result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
            return result;
        }

        public String toString() {
            return "Pickaxe.InfrastructureStats(id=" + this.getId() + ", stats=" + this.getStats() + ")";
        }

        public static class InfrastructureStatsBuilder {
            private int id;
            private ArrayList<String> stats$key;
            private ArrayList<Object> stats$value;

            InfrastructureStatsBuilder() {
            }

            @JsonProperty(value="id")
            public InfrastructureStatsBuilder id(int id) {
                this.id = id;
                return this;
            }

            public InfrastructureStatsBuilder stat(String statKey, Object statValue) {
                if (this.stats$key == null) {
                    this.stats$key = new ArrayList();
                    this.stats$value = new ArrayList();
                }
                this.stats$key.add(statKey);
                this.stats$value.add(statValue);
                return this;
            }

            public InfrastructureStatsBuilder stats(Map<? extends String, ? extends Object> stats) {
                if (stats == null) {
                    throw new NullPointerException("stats cannot be null");
                }
                if (this.stats$key == null) {
                    this.stats$key = new ArrayList();
                    this.stats$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : stats.entrySet()) {
                    this.stats$key.add($lombokEntry.getKey());
                    this.stats$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public InfrastructureStatsBuilder clearStats() {
                if (this.stats$key != null) {
                    this.stats$key.clear();
                    this.stats$value.clear();
                }
                return this;
            }

            public InfrastructureStats build() {
                Map<String, Object> stats;
                switch (this.stats$key == null ? 0 : this.stats$key.size()) {
                    case 0: {
                        stats = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        stats = Collections.singletonMap(this.stats$key.get(0), this.stats$value.get(0));
                        break;
                    }
                    default: {
                        stats = new LinkedHashMap<String, Object>(this.stats$key.size() < 0x40000000 ? 1 + this.stats$key.size() + (this.stats$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.stats$key.size(); ++$i) {
                            stats.put(this.stats$key.get($i), this.stats$value.get($i));
                        }
                        stats = Collections.unmodifiableMap(stats);
                    }
                }
                return new InfrastructureStats(this.id, stats);
            }

            public String toString() {
                return "Pickaxe.InfrastructureStats.InfrastructureStatsBuilder(id=" + this.id + ", stats$key=" + this.stats$key + ", stats$value=" + this.stats$value + ")";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InfrastructureConfig {
        @JsonProperty(value="id")
        public int id;
        @JsonProperty(value="info")
        public Map<String, Object> info;
        @JsonProperty(value="isFast")
        public boolean isFast;
        @JsonProperty(value="type")
        public InfrastructureType type;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CancelledCommands {
        @JsonProperty(value="cancelledIds")
        public List<String> cancelledIds;
    }
}

