/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.tags;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.tags.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagsImpl
implements Tags {
    private static final Logger LOG = LoggerFactory.getLogger(TagsImpl.class);
    private final ObjectMapper objectMapper;
    private final WebUtil webUtil;

    public TagsImpl(ObjectMapper objectMapper, WebUtil webUtil) {
        this.webUtil = webUtil;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean tag(int minerId, List<String> tags) {
        try {
            return this.webUtil.post(String.format("/api/tags/%d", minerId), this.objectMapper.writeValueAsString(tags)).map(s -> s.toLowerCase().contains("okay")).orElse(false);
        }
        catch (Exception e) {
            LOG.warn("Exception occurred while creating tags", (Throwable)e);
            return false;
        }
    }
}

