/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum InfrastructureType {
    ANTSPACE_COOLING_TOWER("bitmain-liquid-cooling-tower"),
    GENERIC_SNMP("generic-snmp"),
    FORTINET_SWITCH("fortinet-switch"),
    MOONSHOT_PDU("moonshot-pdu"),
    OIT_PDU("oit-pdu"),
    TRILOGY_PDU("trilogy-pdu"),
    MANAGED_SWITCH("managed-switch"),
    CPOWER("cpower"),
    GENERIC_MODBUS("generic-modbus"),
    NU_ENERGEN("nuenergen"),
    OIT_RPDU("oit-rpdu-pdu"),
    POWERNET_PDU("powernet-pdu"),
    GRID_BEYOND("grid-beyond"),
    NVIDIA("nvidia"),
    OGE_RTAC("oge-rtac"),
    DIGITAL_SHOVEL_PDU("digital-shovel-pdu"),
    BASIN_RTAC("basin-rtac"),
    PME_RTAC("pme-rtac"),
    SHELL_RTAC("shell-rtac");

    private static final Map<String, InfrastructureType> MAPPINGS;
    private final String type;

    private InfrastructureType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static InfrastructureType forValue(String value) {
        return MAPPINGS.get(value);
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    static {
        MAPPINGS = new ConcurrentHashMap<String, InfrastructureType>();
        for (InfrastructureType type : InfrastructureType.values()) {
            MAPPINGS.put(type.getType(), type);
        }
    }
}

