/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.actions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mn.foreman.api.JsonUtils;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.actions.Actions;
import mn.foreman.api.endpoints.actions.StatusRunning;
import mn.foreman.api.model.Network;
import mn.foreman.api.model.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionsImpl
implements Actions {
    private static final Logger LOG = LoggerFactory.getLogger(ActionsImpl.class);
    private final ObjectMapper objectMapper;
    private final WebUtil webUtil;

    public ActionsImpl(ObjectMapper objectMapper, WebUtil webUtil) {
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public Optional<Actions.Response> changeNetwork(int minerId, Network network, boolean compress) {
        return this.runAction(minerId, "network", network, compress);
    }

    @Override
    public Optional<Actions.Response> changePools(int minerId, List<Pool> pools, boolean compress) {
        return this.runAction(minerId, "change-pools", pools.stream().map(pool -> ImmutableMap.of((Object)"url", (Object)pool.getUrl(), (Object)"user", (Object)pool.getUsername(), (Object)"pass", (Object)pool.getPassword())).collect(Collectors.toList()), compress);
    }

    @Override
    public Optional<Actions.Response> changePowerMode(int minerId, Actions.PowerMode mode, boolean compress) {
        return this.runAction(minerId, "power-mode", ImmutableMap.of((Object)"powerMode", (Object)mode.name().toLowerCase()), compress);
    }

    @Override
    public Optional<StatusRunning> status(int command) {
        Optional<StatusRunning> result = Optional.empty();
        Optional<String> response = this.webUtil.get(String.format("/api/actions/status/%d", command));
        if (response.isPresent()) {
            result = JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<StatusResult>(){}).map(statusResult -> statusResult.status);
        }
        return result;
    }

    private Optional<Actions.Response> runAction(int minerId, String action, Object args, boolean compress) {
        Optional<Actions.Response> result = Optional.empty();
        try {
            Optional<String> response = this.webUtil.post(String.format("/api/actions/%s/%d", action, minerId), this.objectMapper.writeValueAsString(args), compress);
            if (response.isPresent()) {
                result = JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<Actions.Response>(){});
            }
        }
        catch (JsonProcessingException e) {
            LOG.warn("Exception occurred while parsing json", (Throwable)e);
        }
        return result;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class StatusResult {
        @JsonProperty(value="status")
        public StatusRunning status;

        private StatusResult() {
        }
    }
}

