/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.pickaxe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mn.foreman.api.JsonUtils;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.miners.Miners;
import mn.foreman.api.endpoints.pickaxe.Pickaxe;
import mn.foreman.api.model.CommandDone;
import mn.foreman.api.model.CommandDoneBatch;
import mn.foreman.api.model.CommandStart;
import mn.foreman.api.model.CommandStartBatch;
import mn.foreman.api.model.CommandUpdate;
import mn.foreman.api.model.CommandUpdateBatch;
import mn.foreman.api.model.Commands;
import mn.foreman.api.model.MacUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickaxeImpl
implements Pickaxe {
    private static final Logger LOG = LoggerFactory.getLogger(PickaxeImpl.class);
    private final String clientId;
    private final ObjectMapper objectMapper;
    private final String pickaxeId;
    private final WebUtil webUtil;

    public PickaxeImpl(String clientId, String pickaxeId, ObjectMapper objectMapper, WebUtil webUtil) {
        this.clientId = clientId;
        this.pickaxeId = pickaxeId;
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public List<Pickaxe.PickaxeInstance> all() {
        return this.webUtil.get(String.format("/api/pickaxe/%s", this.clientId)).flatMap(s -> JsonUtils.fromJson(s, this.objectMapper, new TypeReference<List<Pickaxe.PickaxeInstance>>(){})).orElse(Collections.emptyList());
    }

    @Override
    public Optional<List<String>> cancelCommands() {
        return this.webUtil.post(String.format("/api/pickaxe/%s/commands/cancel", this.pickaxeId)).flatMap(s -> JsonUtils.fromJson(s, this.objectMapper, new TypeReference<Pickaxe.CancelledCommands>(){}).map(cancelledCommands -> cancelledCommands.cancelledIds));
    }

    @Override
    public Optional<CommandDone.Response> commandDone(CommandDone done, String commandId, boolean compress) {
        return this.runStandardCommand(done, String.format("/api/pickaxe/%s/command/%s/done", this.pickaxeId, commandId), compress);
    }

    @Override
    public Optional<CommandDoneBatch.Response> commandDoneBatch(CommandDoneBatch done, boolean compress) {
        return this.runStandardCommand(done, "/api/pickaxe/%s/command/done", compress);
    }

    @Override
    public Optional<CommandStart.Response> commandStarted(CommandStart start, boolean compress) {
        return this.runStandardCommand(start, String.format("/api/pickaxe/%s/command/%s/start", this.pickaxeId, start.id), compress);
    }

    @Override
    public Optional<CommandStartBatch.Response> commandStartedBatch(CommandStartBatch start, boolean compress) {
        return this.runStandardCommand(start, "/api/pickaxe/%s/command/start", compress);
    }

    @Override
    public Optional<CommandUpdate.Response> commandUpdate(CommandUpdate update, String commandId, boolean compress) {
        return this.runStandardCommand(update, String.format("/api/pickaxe/%s/command/%s/update", this.pickaxeId, commandId), compress);
    }

    @Override
    public Optional<CommandUpdateBatch.Response> commandUpdateBatch(CommandUpdateBatch update, boolean compress) {
        return this.runStandardCommand(update, "/api/pickaxe/%s/command/update", compress);
    }

    @Override
    public Optional<Pickaxe.PickaxeConfiguration> config() {
        Optional<String> response = this.webUtil.get(String.format("/api/pickaxe/%s/appConfig", this.pickaxeId));
        if (response.isPresent()) {
            return JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<Pickaxe.PickaxeConfiguration>(){});
        }
        return Optional.empty();
    }

    @Override
    public Optional<Commands> getCommands() {
        Optional<String> response = this.webUtil.get(String.format("/api/pickaxe/%s/commands", this.pickaxeId));
        if (response.isPresent()) {
            return JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<Commands>(){});
        }
        return Optional.empty();
    }

    @Override
    public Optional<List<Pickaxe.InfrastructureConfig>> infrastructureConfigs() {
        return this.webUtil.get(String.format("/api/pickaxe/%s/devices-config", this.pickaxeId)).flatMap(s -> JsonUtils.fromJson(s, this.objectMapper, new TypeReference<List<Pickaxe.InfrastructureConfig>>(){}));
    }

    @Override
    public boolean infrastructureUpdate(List<Pickaxe.InfrastructureStats> stats, boolean compress) {
        try {
            this.webUtil.post(String.format("/api/pickaxe/%s/devices-update", this.pickaxeId), this.objectMapper.writeValueAsString(stats), compress);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to publish infrastructure stats: {}", stats, (Object)e);
            return false;
        }
    }

    @Override
    public Optional<List<Pickaxe.MinerConfig>> minerConfigs(String version, String hostname, String hostIp) {
        return this.webUtil.get(String.format("/api/config/%s/%s/%s/", this.clientId, this.pickaxeId, version), (Map<String, String>)ImmutableMap.of((Object)"hostname", (Object)hostname, (Object)"ip", (Object)hostIp)).flatMap(s -> JsonUtils.fromJson(s, this.objectMapper, new TypeReference<List<Pickaxe.MinerConfig>>(){}));
    }

    @Override
    public boolean started() {
        return this.webUtil.post(String.format("/api/pickaxe/%s/started", this.pickaxeId)).map(s -> s.contains("success")).orElse(false);
    }

    @Override
    public boolean updateMacs(Map<Miners.Miner, String> newMacs, boolean compress) {
        boolean updated = false;
        List macUpdates = Lists.partition(newMacs.entrySet().stream().map(entry -> {
            Miners.Miner miner = (Miners.Miner)entry.getKey();
            return MacUpdate.builder().ip(miner.apiIp).apiPort(miner.apiPort).mac((String)entry.getValue()).build();
        }).collect(Collectors.toList()), (int)100);
        if (!macUpdates.isEmpty()) {
            for (List update : macUpdates) {
                try {
                    Optional<String> response = this.webUtil.post(String.format("/api/pickaxe/%s/macs", this.pickaxeId), this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"updates", (Object)update)), compress);
                    if (!response.isPresent()) continue;
                    LOG.info("Received response: {}", response);
                    updated = true;
                }
                catch (JsonProcessingException e) {
                    LOG.warn("Exception occurred while parsing json", (Throwable)e);
                }
            }
        } else {
            updated = true;
        }
        return updated;
    }

    private <T, R> Optional<R> runStandardCommand(T command, String uri, boolean compress) {
        Optional result = Optional.empty();
        try {
            Optional<String> response = this.webUtil.post(String.format(uri, this.pickaxeId), this.objectMapper.writeValueAsString(command), compress);
            if (response.isPresent()) {
                result = JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<R>(){});
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred while parsing json", (Throwable)e);
        }
        return result;
    }
}

