/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.qse.prioritypower;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import mn.foreman.api.JsonUtils;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.qse.prioritypower.PriorityPower;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityPowerImpl
implements PriorityPower {
    private static final Logger LOG = LoggerFactory.getLogger(PriorityPowerImpl.class);
    private final ObjectMapper objectMapper;
    private final String pickaxeId;
    private final WebUtil webUtil;

    public PriorityPowerImpl(String pickaxeId, ObjectMapper objectMapper, WebUtil webUtil) {
        this.pickaxeId = pickaxeId;
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public Optional<PriorityPower.CurrentLoad> updateRtacStats(boolean is4Cp, double basePoint, double targetSetPoint, double consumptionWatts, double frequency, boolean compress) {
        Optional<PriorityPower.CurrentLoad> currentLoad = Optional.empty();
        try {
            Optional<String> response = this.webUtil.post(String.format("/api/v2/qse/prioritypower/rtac/%s/state", this.pickaxeId), this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"is4Cp", (Object)is4Cp, (Object)"basePoint", (Object)basePoint, (Object)"targetSetPoint", (Object)targetSetPoint, (Object)"consumptionWatts", (Object)consumptionWatts, (Object)"frequency", (Object)frequency)), compress);
            if (response.isPresent()) {
                currentLoad = JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<PriorityPower.CurrentLoad>(){});
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to update RTAC stats", (Throwable)e);
        }
        return currentLoad;
    }
}

