/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.sitemap;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import mn.foreman.api.JsonUtils;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.sitemap.SiteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteMapImpl
implements SiteMap {
    private static final Logger LOG = LoggerFactory.getLogger(SiteMapImpl.class);
    private final ObjectMapper objectMapper;
    private final WebUtil webUtil;

    public SiteMapImpl(ObjectMapper objectMapper, WebUtil webUtil) {
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public Optional<SiteMap.Response> setLocation(int minerId, String rack, int row, int index, boolean compress) {
        Optional<SiteMap.Response> result = Optional.empty();
        try {
            Optional<String> response = this.webUtil.post(String.format("/api/site-map/location/%d", minerId), this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"rack", (Object)rack, (Object)"row", (Object)row, (Object)"index", (Object)index)), compress);
            if (response.isPresent()) {
                result = JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<SiteMap.Response>(){});
            }
        }
        catch (JsonProcessingException e) {
            LOG.warn("Exception occurred while parsing json", (Throwable)e);
        }
        return result;
    }
}

