package mn.lambda.paypro.sdk

import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.content.ServiceConnection
import android.os.IBinder
import android.os.RemoteException
import android.util.Log
import com.google.gson.Gson
import com.lambda.paypro.IPayProListener
import com.lambda.paypro.IPayProService
import java.lang.reflect.Type

class PayProClient<T>(private val context: Context, private val timeout: Int,
        private val action: String,
        private val payload: String?, private val responseClass: Type, private val callback: (PayProResponse<T>) -> Unit) {

    private var mService: IPayProService? = null

    fun execute(){
        val intent = Intent()
        intent.action = "android.intent.action.PAYPRO.SERVICE"
        intent.setPackage("com.lambda.paypro")
        val bindResult = this.context.bindService(intent, mConnection, Context.BIND_AUTO_CREATE)
        Log.d("PayPro-SDK", "bind service--------------$bindResult")
    }

    private fun unbindPayProService() {
        context.unbindService(mConnection)
    }

    private fun interceptResponse(result: String, responseClass: Type): T {
//        Log.d("PayPro-SDK", "before to json: $result")
        val gsonConverter = Gson()
        val obj: Any = gsonConverter.fromJson(result, Any::class.java)
        val str = gsonConverter.toJson(obj)
//        Log.d("PayPro-SDK", "to json: $str")
        return gsonConverter.fromJson(str, responseClass)
    }

    private val mPaymentListener = object : IPayProListener.Stub() {
        override fun onResult(succeed: Boolean, message: String?, result: String?) {
            this@PayProClient.unbindPayProService()
            Log.d("PayPro-SDK", "onResult: $succeed, [$message], [$result]")
            if(succeed){
                result?.let { res ->
                    try {
                        callback.invoke(PayProResponse.Success(interceptResponse(res, responseClass)))
                    }
                    catch (ex: Error) {
                        callback.invoke(PayProResponse.Error(ex.message ?: "Хариу боловсруулахад алдаа гарлаа"))
                    }
                } ?: run {
                    callback.invoke(PayProResponse.Error(message ?: "Алдаа гарлаа"))
                }
            }
            else {
                callback.invoke(PayProResponse.Error(message ?: "Алдаа гарлаа"))
            }
        }
    }

    private val mConnection = object : ServiceConnection {

        override fun onServiceConnected(className: ComponentName, service: IBinder) {
            mService = IPayProService.Stub.asInterface(service)
            Log.d("PayPro-SDK", "On service connected...")

            try {
                mService?.run(timeout, action, payload, mPaymentListener)
            } catch (e: RemoteException) {
                callback(PayProResponse.Error(e.message ?: "Системийн алдаа"))
                e.printStackTrace()
            }
        }

        override fun onServiceDisconnected(className: ComponentName) {
            Log.d("PayPro-SDK", "on service disconnected")
            mService = null
        }

        override fun onBindingDied(name: ComponentName?) {
            super.onBindingDied(name)
            Log.d("PayPro-SDK", "on binding died, $name")
        }

        override fun onNullBinding(name: ComponentName?) {
            super.onNullBinding(name)
            Log.d("PayPro-SDK", "on null binding, $name")
        }
    }

}
