package mn.lambda.paypro.sdk

import android.content.Context

class PayProApi(private val bank: String? = null) {

    fun readCardUID(context: Context, timeout: Int, callback: (PayProResponse<NFCCard>) -> Unit) {
        val client = PayProClient(context, timeout, "cardUID", null, NFCCard::class.java, callback)
        client.execute(bank)
    }

    fun getDeviceInfo(context: Context, callback: (PayProResponse<DeviceInfo>) -> Unit) {
        val client = PayProClient(context, 10, "deviceInfo", null, DeviceInfo::class.java, callback)
        client.execute(bank)
    }

    fun print(context: Context, payload: String, callback: (PayProResponse<Empty>) -> Unit) {
        val client = PayProClient(context, 10, "print", payload, Empty::class.java, callback)
        client.execute(bank)
    }
}
