package mn.lambda.paypro.sdk.printer

import android.os.Parcel
import android.os.Parcelable
import androidx.annotation.IntRange

/**
 * The image item to be printed.
 *
 */
class PrintImageItem (
    val base64Image: String,
    @IntRange(from = 0, to = 100) widthPercent: Int = 100,
    align: Int = PrintItemAlign.CENTER) : PrintItem(widthPercent, align, PrintItemType.IMAGE) {
    constructor(parcel: Parcel) : this(
        parcel.readString() ?: "",
        parcel.readInt(),
        parcel.readInt(),
    )

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(base64Image)
        parcel.writeInt(widthPercent)
        parcel.writeInt(align)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PrintImageItem> {
        override fun createFromParcel(parcel: Parcel): PrintImageItem {
            return PrintImageItem(parcel)
        }

        override fun newArray(size: Int): Array<PrintImageItem?> {
            return arrayOfNulls(size)
        }
    }

}
