package mn.lambda.paypro.sdk.printer

import android.os.Parcel
import android.os.Parcelable

/**
 * skip paper item
 *
 */
class PrintPaperSkipItem constructor(val height: Float) : PrintItem(100, PrintItemAlign.CENTER, PrintItemType.SKIP){
    constructor(parcel: Parcel) : this(
        parcel.readFloat(),
    )

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeFloat(height)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PrintPaperSkipItem> {
        override fun createFromParcel(parcel: Parcel): PrintPaperSkipItem {
            return PrintPaperSkipItem(parcel)
        }

        override fun newArray(size: Int): Array<PrintPaperSkipItem?> {
            return arrayOfNulls(size)
        }
    }

}
