package mn.lambda.paypro.sdk.printer

import android.os.Parcel
import android.os.Parcelable
import androidx.annotation.IntRange

/**
 * The QR code item to be printed.
 *
 */
class PrintQrCodeItem (val qrCode: String,
                     val height: Int,
                     @IntRange(from = 0, to = 100) widthPercent: Int = 100,
                     align: Int = PrintItemAlign.CENTER) : PrintItem(widthPercent, align, PrintItemType.QRCODE) {
    constructor(parcel: Parcel) : this(
        parcel.readString() ?: "",
        parcel.readInt(),
        parcel.readInt(),
        parcel.readInt(),
    )

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(qrCode)
        parcel.writeInt(height)
        parcel.writeInt(widthPercent)
        parcel.writeInt(align)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PrintQrCodeItem> {
        override fun createFromParcel(parcel: Parcel): PrintQrCodeItem {
            return PrintQrCodeItem(parcel)
        }

        override fun newArray(size: Int): Array<PrintQrCodeItem?> {
            return arrayOfNulls(size)
        }
    }

}
