package mn.lambda.paypro.sdk.printer

import android.graphics.Bitmap
import com.google.zxing.BarcodeFormat
import com.google.zxing.EncodeHintType
import com.google.zxing.MultiFormatWriter
import com.google.zxing.WriterException
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel
import java.nio.charset.StandardCharsets
import java.util.*
import kotlin.text.get

/**
 * QR code utils
 *
 * @author Janson
 * @date 2021/3/24 15:50
 */
object QRCodeUtils {
    /**
     * Create QR code bitmap
     *
     * @param code QR code
     * @return QR code
     * @throws WriterException create failed
     */
    @Throws(WriterException::class)
    fun create2dCode(code: String?): Bitmap {
        return create2dCodeSized(code, 300)
    }
    @Throws(WriterException::class)
    fun create2dCodeSized(code: String?, witdh: Int): Bitmap {
        val matrix = MultiFormatWriter().encode(
            code,
            BarcodeFormat.QR_CODE, witdh, witdh
        )
        val width = matrix.width
        val height = matrix.height
        val pixels = IntArray(width * height)
        for (y in 0 until height) {
            for (x in 0 until width) {
                if (matrix[x, y]) {
                    pixels[y * width + x] = -0x1000000
                }
            }
        }
        val bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888)
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height)
        return bitmap
    }
    /**
     * Create QR code bitmap
     *
     * @param code  QR code
     * @param qrLen bitmap side length
     * @param errorCorrection error correction level
     * @return QR code
     * @throws WriterException create failed
     */
    /**
     * Create QR code bitmap
     *
     * @param code  QR code
     * @param qrLen bitmap side length
     * @return QR code
     * @throws WriterException create failed
     */
    @JvmOverloads
    @Throws(WriterException::class)
    fun create2dCode(
        code: String,
        qrLen: Int,
        errorCorrection: ErrorCorrectionLevel? = ErrorCorrectionLevel.L
    ): Bitmap {
        val hints = Hashtable<EncodeHintType, Any?>()
        hints[EncodeHintType.MARGIN] = 1
        hints[EncodeHintType.CHARACTER_SET] = StandardCharsets.UTF_8.name()
        hints[EncodeHintType.ERROR_CORRECTION] = errorCorrection
        val bitMatrix = MultiFormatWriter().encode(code, BarcodeFormat.QR_CODE, qrLen, qrLen, hints)
        val pixels = IntArray(qrLen * qrLen)
        for (y in 0 until qrLen) {
            for (x in 0 until qrLen) {
                if (bitMatrix[x, y]) {
                    pixels[y * qrLen + x] = -0x1000000
                } else {
                    pixels[y * qrLen + x] = -0x1
                }
            }
        }
        val bitmap = Bitmap.createBitmap(qrLen, qrLen, Bitmap.Config.ARGB_8888)
        bitmap.setPixels(pixels, 0, qrLen, 0, 0, qrLen, qrLen)
        return bitmap
    }
}
