package mn.lambda.paypro.sdk

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.activity.result.ActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.fragment.app.Fragment
import mn.lambda.paypro.sdk.payment.card.CardPaymentResult

class PayProApi(private val bank: String? = null) {

    fun readCardUID(context: Context, timeout: Int, callback: (PayProResponse<NFCCard>) -> Unit) {
        val client = PayProClient(context, timeout, "cardUID", null, NFCCard::class.java, callback)
        client.execute(bank)
    }

    fun getDeviceInfo(context: Context, callback: (PayProResponse<DeviceInfo>) -> Unit) {
        val client = PayProClient(context, 10, "deviceInfo", null, DeviceInfo::class.java, callback)
        client.execute(bank)
    }

    fun print(context: Context, payload: String, callback: (PayProResponse<Empty>) -> Unit) {
        val client = PayProClient(context, 10, "print", payload, Empty::class.java, callback)
        client.execute(bank)
    }

    fun cardPayment(fragment: Fragment, amount: Double, callback: (PayProResponse<CardPaymentResult>) -> Unit, bundle: Bundle? = null){
        val mStartForCardPaymentResult = fragment.registerForActivityResult(
            ActivityResultContracts.StartActivityForResult()
        ) { result: ActivityResult ->
            Log.d("PayPRO SDK", "result: " + result.resultCode)
            result.data?.extras?.let {
                it.keySet().forEach { key ->
                    Log.d("PayPRO SDK", "$key: ${it.get(key)}")
                }
                val succeed = it.getBoolean("succeed")
                Log.d("PayPRO SDK", "succeed: $succeed")

                val amount = it.getDouble("amount")
                val traceno = it.getString("traceno", "")
                val batchno = it.getString("batchno", "")
                val maskedPAN = it.getString("maskedPAN", "")
                val systemRef = it.getString("systemRef", "")
                val approveCode = it.getString("approveCode", "")
                val merchantId = it.getString("merchantId", "")
                val terminalId = it.getString("terminalId", "")

                if(succeed){
                    val paymentResult = CardPaymentResult(merchantId, terminalId, amount, traceno, batchno, maskedPAN, systemRef, approveCode)
                    callback(PayProResponse.Success(paymentResult))
                }
                else {
                    callback(PayProResponse.Error(it.getString("message", "Гүйлгээ амжилтгүй")))
                }
            } ?: run {
                callback(PayProResponse.Error("Системийн алдаа"))
            }
        }

        val b = bundle ?: Bundle()
        b.putDouble("amount", amount)
        b.putInt("payment", 1) // 1 == Card
        b.putBoolean("skipPrint", true)
        mStartForCardPaymentResult.launch(Intent("com.lambda.paypro.app.payment.purchase.open").putExtras(b))
    }

}
