package mn.lambda.paypro.sdk.printer

import android.os.Parcel
import android.os.Parcelable
import androidx.annotation.IntRange

/**
 * The text item to be printed.
 *
 */
class PrintTextItem (val text: String,
                     val textSize: Float,
                     val isBold: Boolean = false,
                     @IntRange(from = 0, to = 100) widthPercent: Int = 100,
                     align: Int = PrintItemAlign.CENTER) : PrintItem(widthPercent, align, PrintItemType.TEXT) {

    constructor(parcel: Parcel) : this(
        parcel.readString() ?: "",
        parcel.readFloat(),
        parcel.readBoolean(),
        parcel.readInt(),
        parcel.readInt(),
    )

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(text)
        parcel.writeFloat(textSize)
        parcel.writeBoolean(isBold)
        parcel.writeInt(widthPercent)
        parcel.writeInt(align)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PrintTextItem> {
        override fun createFromParcel(parcel: Parcel): PrintTextItem {
            return PrintTextItem(parcel)
        }

        override fun newArray(size: Int): Array<PrintTextItem?> {
            return arrayOfNulls(size)
        }
    }

}
