package mn.lambda.paypro.sdk

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.activity.result.ActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AppCompatActivity
import mn.lambda.paypro.sdk.payment.card.CardPaymentResult

class PayProApi(private val bank: String? = null) {

    fun readCardUID(context: Context, timeout: Int, callback: (PayProResponse<NFCCard>) -> Unit) {
        val client = PayProClient(context, timeout, "cardUID", null, NFCCard::class.java, callback)
        client.execute(bank)
    }

    fun getDeviceInfo(context: Context, callback: (PayProResponse<DeviceInfo>) -> Unit) {
        val client = PayProClient(context, 10, "deviceInfo", null, DeviceInfo::class.java, callback)
        client.execute(bank)
    }

    fun print(context: Context, payload: String, callback: (PayProResponse<Empty>) -> Unit) {
        val client = PayProClient(context, 10, "print", payload, Empty::class.java, callback)
        client.execute(bank)
    }

    fun cardPayment(
        context: Context,
        amount: Double,
        callback: (PayProResponse<CardPaymentResult>) -> Unit
    ) {
        val reqId = RequestRegistry.enqueue(callback)
        val i = Intent(context, PayProProxyActivity::class.java).apply {
            putExtra(PayProProxyActivity.EXTRA_AMOUNT, amount)
            putExtra(PayProProxyActivity.EXTRA_REQ_ID, reqId)
            addFlags(Intent.FLAG_ACTIVITY_NEW_TASK) // allows Application context
        }
        context.startActivity(i)
    }
}
