package mn.lambda.paypro.sdk

import android.content.Intent
import android.os.Bundle
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AppCompatActivity
import mn.lambda.paypro.sdk.payment.card.CardPaymentResult
import java.util.UUID
import java.util.concurrent.ConcurrentHashMap

class PayProProxyActivity : AppCompatActivity() {

    private val launcher = registerForActivityResult(
        ActivityResultContracts.StartActivityForResult()
    ) { result ->
        val extras = result.data?.extras
        val reqId = intent.getStringExtra(EXTRA_REQ_ID) ?: return@registerForActivityResult
        RequestRegistry.complete(reqId, extras)
        finish()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val amount = intent.getDoubleExtra(EXTRA_AMOUNT, 0.0)
        val reqId = intent.getStringExtra(EXTRA_REQ_ID)!!

        val b = Bundle().apply {
            putString("reqId", reqId)
            putDouble("amount", amount)
            putInt("payment", 1)
            putBoolean("skipPrint", true)
        }

        launcher.launch(Intent("com.lambda.paypro.app.payment.purchase.open").putExtras(b))
    }

    companion object {
        const val EXTRA_AMOUNT = "amount"
        const val EXTRA_REQ_ID = "reqId"
    }
}

// Simple in-process registry
internal object RequestRegistry {
    private val map = ConcurrentHashMap<String, (PayProResponse<CardPaymentResult>) -> Unit>()

    fun enqueue(cb: (PayProResponse<CardPaymentResult>) -> Unit): String =
        UUID.randomUUID().toString().also { map[it] = cb }

    fun complete(reqId: String, it: Bundle?) {
        val cb = map.remove(reqId) ?: return
        if (it != null && it.getBoolean("succeed")) {
            cb(
                PayProResponse.Success(
                    CardPaymentResult(
                        merchantId  = it.getString("merchantId", ""),
                        terminalId  = it.getString("terminalId", ""),
                        amount      = it.getDouble("amount"),
                        traceno     = it.getString("traceno", ""),
                        batchno     = it.getString("batchno", ""),
                        maskedPAN   = it.getString("maskedPAN", ""),
                        systemRef   = it.getString("systemRef", ""),
                        approveCode = it.getString("approveCode", "")
                    )
                )
            )
        } else {
            cb(PayProResponse.Error(it?.getString("message", "Гүйлгээ амжилтгүй") ?: "Системийн алдаа"))
        }
    }
}