package mn.lambda.paypro.sdk.printer

import android.graphics.*
import android.text.TextPaint
import com.google.zxing.BarcodeFormat
import com.google.zxing.MultiFormatWriter
import com.google.zxing.WriterException
import com.google.zxing.common.BitMatrix
import kotlin.text.get

/**
 * Bar code utils
 *
 * @author Janson
 * @date 2021/3/24 15:46
 */
object BarCodeUtils {
    private const val BLACK = -0x1000000
    private const val WHITE = -0x1

    /**
     * Create bar code bitmap
     *
     * @param code          bar code
     * @param format        bar type,such as：BarcodeFormat.CODE_128
     * @param desiredWidth  bar width,such as： 400
     * @param desiredHeight bar height,such as： 100
     * @return bar code bitmap
     */
    fun createBarCode(
        code: String?,
        format: BarcodeFormat?,
        desiredWidth: Int,
        desiredHeight: Int
    ): Bitmap {
        var result: BitMatrix? = null
        try {
            result = MultiFormatWriter().encode(code, format, desiredWidth, desiredHeight, null)
        } catch (e: WriterException) {
            e.printStackTrace()
        }
        val width = result!!.width
        val height = result.height
        val pixels = IntArray(width * height)
        // All are 0, or black, by default
        for (y in 0 until height) {
            val offset = y * width
            for (x in 0 until width) {
                // pixels[offset + x] = result.get(x, y) ? WHITE :BLACK ;
                if (result[x, y]) {
                    pixels[offset + x] = BLACK
                } else {
                    pixels[offset + x] = WHITE
                }
            }
        }
        val bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888)
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height)
        return bitmap
    }

    /**
     * Create bar code bitmap with text
     *
     * @param code          bar code
     * @param format        bar type,such as：BarcodeFormat.CODE_128
     * @param desiredWidth  bar width,such as： 400
     * @param desiredHeight bar height,such as： 100
     * @return bar code bitmap
     */
    fun createBarCodeWithText(
        code: String?,
        format: BarcodeFormat?,
        desiredWidth: Int,
        desiredHeight: Int
    ): Bitmap? {
        val writer = MultiFormatWriter()
        val result: BitMatrix
        result = try {
            writer.encode(code, format, desiredWidth, desiredHeight, null)
        } catch (e: Exception) {
            e.printStackTrace()
            return null
        }
        val width = result.width
        val height = result.height
        val pixels = IntArray(width * height)
        for (y in 0 until height) {
            val offset = y * width
            for (x in 0 until width) {
                pixels[offset + x] = if (result[x, y]) BLACK else WHITE
            }
        }
        val bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888)
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height)
        val nBitmp = Bitmap.createBitmap(width, height + 30, Bitmap.Config.ARGB_8888)
        val c = Canvas(nBitmp)
        val cm = ColorMatrix()
        cm.setSaturation(0f)
        val paint = Paint()
        val f = ColorMatrixColorFilter(cm)
        paint.colorFilter = f
        c.drawColor(WHITE)
        c.drawBitmap(bitmap, 0f, 0f, paint)
        // draw text
        val textPaint = TextPaint()
        textPaint.style = Paint.Style.FILL
        textPaint.textSize = 20f
        textPaint.color = BLACK
        textPaint.strokeWidth = 0.5f
        textPaint.textAlign = Paint.Align.CENTER
        textPaint.colorFilter = f
        c.drawText(code!!, (width / 2).toFloat(), (height + 20).toFloat(), textPaint)
        textPaint.color = WHITE
        textPaint.strokeWidth = 10f
        c.drawLine(0f, 0f, width.toFloat(), 0f, textPaint)
        c.save()
        c.restore()
        return nBitmp
    }
}
