package mn.lambda.paypro.sdk.printer

import android.os.Parcel
import android.os.Parcelable
import androidx.annotation.IntRange

/**
 * The barcode item to be printed.
 *
 */
class PrintBarCodeItem (val barcode: String,
                        val width: Int,
                        val height: Int,
                        @IntRange(from = 0, to = 100) widthPercent: Int = 100,
                        align: Int = PrintItemAlign.CENTER) : PrintItem(widthPercent, align, PrintItemType.BARCODE) {
    constructor(parcel: Parcel) : this(
        parcel.readString() ?: "",
        parcel.readInt(),
        parcel.readInt(),
        parcel.readInt(),
        parcel.readInt(),
    )

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(barcode)
        parcel.writeInt(height)
        parcel.writeInt(height)
        parcel.writeInt(widthPercent)
        parcel.writeInt(align)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PrintBarCodeItem> {
        override fun createFromParcel(parcel: Parcel): PrintBarCodeItem {
            return PrintBarCodeItem(parcel)
        }

        override fun newArray(size: Int): Array<PrintBarCodeItem?> {
            return arrayOfNulls(size)
        }
    }

}
