package mn.lambda.paypro.sdk.printer

import android.os.Parcel
import android.os.Parcelable
import androidx.annotation.IntRange


object PrintItemAlign {
    val LEFT = 1
    val CENTER = 2
    val RIGHT = 3
}

object PrintItemType {
    val NONE = 0
    val TEXT = 1
    val IMAGE = 2
    val BARCODE = 3
    val QRCODE = 4
    val SKIP = 5
}

open class PrintItem(@IntRange(from = 0, to = 100) var widthPercent: Int = 100, val align: Int = PrintItemAlign.CENTER, val type: Int = PrintItemType.NONE): Parcelable {
    constructor(parcel: Parcel) : this(
        parcel.readInt(),
        parcel.readInt(),
        parcel.readInt()
    )

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeInt(widthPercent)
        parcel.writeInt(align)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PrintItem> {
        override fun createFromParcel(parcel: Parcel): PrintItem {
            return PrintItem(parcel)
        }

        override fun newArray(size: Int): Array<PrintItem?> {
            return arrayOfNulls(size)
        }
    }

}
