package mn.lambda.paypro.sdk.printer

import android.content.Context
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.util.Base64
import java.io.ByteArrayOutputStream

abstract class Receipt(val options: PrinterOptions = PrinterOptions("Geologica-SemiBold.ttf","Geologica-Bold.ttf",  23f, 19f, 17f, 0f)) {

    var lines: MutableList<List<PrintItem>> = mutableListOf()

    fun addLine(vararg line: PrintItem){
        lines.add(line.toList())
    }

    protected open fun paperSkip(height: Float){
        addLine(PrintPaperSkipItem(height))
    }

    protected open val SPLITTER = "-------------------------------------"
    protected open val labelPercent = 40

    var receiptType: ReceiptType = ReceiptType.CUSTOMER_COPY
    var isReprint = false

    protected open fun getLogoPath(): String? {
        return null
    }

    protected open fun getTitle(): String? {
        return null
    }

    protected abstract fun getSubTitle(): String?

    protected open fun printHeader() {}

    protected abstract fun printContent()

    protected open fun printFooter() {}

    fun printSplitter() {
        addLine(PrintTextItem(SPLITTER, options.normalTextSize))
    }

    fun printText(
        text: String?,
        align: Int = PrintItemAlign.CENTER,
        textSize: Float = options.normalTextSize,
        isBold: Boolean = false,
    ) {
        text?.let {
            addLine(
                PrintTextItem(it, textSize, isBold, 100, align),
            )
        }
    }

    fun printPair(
        label: String?,
        value: String?,
        labelPercent: Int = this.labelPercent,
        textSize: Float = options.normalTextSize,
        isBold: Boolean = false
    ) {
        if (!label.isNullOrEmpty() && !value.isNullOrEmpty()) {
            addLine(
                PrintTextItem(label, textSize, isBold, labelPercent, PrintItemAlign.LEFT),
                PrintTextItem(value, textSize, isBold, 100 - labelPercent, PrintItemAlign.RIGHT)
            )
        }
    }

    open var isPreRendered = false

    open fun getPrintLines(context: Context, refresh: Boolean = false): List<List<PrintItem>> {
        if (lines.isNotEmpty() && (isPreRendered || !refresh)) {
            return lines
        }

        lines.clear()

        // Print LOGO
        getLogoPath()?.let { path ->
            val bitmap = context.assets
                .open(path)
                .use(BitmapFactory::decodeStream)
            val baos = ByteArrayOutputStream()
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos)
            val b = baos.toByteArray()
            val base64 =
                Base64.encodeToString(b, Base64.NO_WRAP or Base64.NO_PADDING or Base64.URL_SAFE)
            addLine(PrintImageItem(base64))
        }

        // Print Title
        getTitle()?.let {
//            paperSkip(10f)
            addLine(PrintTextItem(it, options.normalTextSize, true, 100, PrintItemAlign.CENTER))
        }

        // Print SubTitle
        getSubTitle()?.let {
//            paperSkip(10f)
            addLine(PrintTextItem(it, options.normalTextSize, false, 100, PrintItemAlign.CENTER))
        }

        // Print header
        printHeader()
        // Print rest of content
        printContent()
        // Print footer
        printFooter()

        paperSkip(20f)

        return lines
    }

}
