/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import mobi.designmyapp.common.api.model.Portal;
import org.jongo.marshall.jackson.oid.Id;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class User {
    @Id
    private String uuid;
    private String firstName;
    private String lastName;
    private String email;
    private String password;
    private boolean emailProtected;
    private boolean locked;
    private Date creationDate;
    private Date lastModifDate;
    private Date lastLoginDate;
    private Portal portal;
    private String phoneNumber;
    private Role role;

    public static Builder builder() {
        return new Builder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isEmailProtected() {
        return this.emailProtected;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getLastModifDate() {
        return this.lastModifDate;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public Portal getPortal() {
        return this.portal;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public Role getRole() {
        return this.role;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmailProtected(boolean emailProtected) {
        this.emailProtected = emailProtected;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setLastModifDate(Date lastModifDate) {
        this.lastModifDate = lastModifDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public void setPortal(Portal portal) {
        this.portal = portal;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String toString() {
        return "User{uuid=" + this.uuid + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", email='" + this.email + '\'' + ", password='" + this.password + '\'' + ", emailProtected=" + this.emailProtected + ", locked=" + this.locked + ", creationDate=" + this.creationDate + ", lastModifDate=" + this.lastModifDate + ", lastLoginDate=" + this.lastLoginDate + ", portal=" + this.portal + ", phoneNumber=" + this.phoneNumber + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return !(this.uuid != null ? !this.uuid.equals(user.uuid) : user.uuid != null);
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public static enum Role {
        USER,
        DEVELOPER,
        ADMIN;

    }

    public static class Builder {
        private User user = new User();

        private Builder() {
        }

        public Builder uuid(String id) {
            this.user.uuid = id;
            return this;
        }

        public Builder firstName(String firstName) {
            this.user.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.user.lastName = lastName;
            return this;
        }

        public Builder email(String email) {
            this.user.email = email;
            return this;
        }

        public Builder password(String password) {
            this.user.password = password;
            return this;
        }

        public Builder emailProtected(boolean emailProtected) {
            this.user.emailProtected = emailProtected;
            return this;
        }

        public Builder locked(boolean locked) {
            this.user.locked = locked;
            return this;
        }

        public Builder creationDate(Date creationDate) {
            this.user.creationDate = creationDate;
            return this;
        }

        public Builder lastModifDate(Date lastModifDate) {
            this.user.lastModifDate = lastModifDate;
            return this;
        }

        public Builder lastLoginDate(Date lastLoginDate) {
            this.user.lastLoginDate = lastLoginDate;
            return this;
        }

        public Builder portal(Portal portal) {
            this.user.portal = portal;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.user.phoneNumber = phoneNumber;
            return this;
        }

        public Builder Role(Role role) {
            this.user.role = role;
            return this;
        }

        public User build() {
            return this.user;
        }
    }
}

