/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.api.resolver;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Map;
import mobi.designmyapp.common.api.model.Generation;

public class GenerationTypeIdResolver
implements TypeIdResolver {
    private JavaType mBaseType;
    private static Map<String, Class<? extends Generation>> generationMap;

    public static void setGenerationMap(Map<String, Class<? extends Generation>> map) {
        generationMap = map;
    }

    public void init(JavaType baseType) {
        this.mBaseType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromBaseType() {
        return this.idFromValueAndType(null, this.mBaseType.getRawClass());
    }

    public String idFromValueAndType(Object obj, Class<?> clazz) {
        for (Map.Entry<String, Class<? extends Generation>> entry : generationMap.entrySet()) {
            if (!entry.getValue().equals(clazz)) continue;
            return entry.getKey();
        }
        return null;
    }

    public JavaType typeFromId(String type) {
        Class<? extends Generation> clazz = generationMap.get(type);
        if (clazz == null) {
            for (Class<? extends Generation> cl : generationMap.values()) {
                if (!cl.getSimpleName().equals(type)) continue;
                clazz = cl;
            }
        }
        if (clazz == null) {
            throw new IllegalStateException("Cannot find generation object");
        }
        return TypeFactory.defaultInstance().constructSpecializedType(this.mBaseType, clazz);
    }
}

