/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.engine.model;

import mobi.designmyapp.common.util.UtilsFactory;

public class Image {
    private String fileName;
    private String originalName;
    private String url;

    private Image() {
    }

    public Image(String fileName, String originalName, String url) {
        this.fileName = fileName;
        this.originalName = originalName;
        this.url = url;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "Image{fileName='" + this.fileName + '\'' + ", originalName='" + this.originalName + '\'' + ", url='" + this.url + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image image = (Image)o;
        if (!this.fileName.equals(image.fileName)) {
            return false;
        }
        if (this.originalName != null ? !this.originalName.equals(image.originalName) : image.originalName != null) {
            return false;
        }
        return this.url.equals(image.url);
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = 31 * result + (this.originalName != null ? this.originalName.hashCode() : 0);
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public static class URLBuilder {
        private Image image;
        private String portal;
        private String appId;
        private String namespace;

        private URLBuilder(Image image) {
            this.image = image;
        }

        public URLBuilder portal(String portal) {
            this.portal = portal;
            return this;
        }

        public URLBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public URLBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Image build() {
            if (this.namespace == null || this.appId == null || this.image.getFileName() == null) {
                throw new IllegalStateException("fileName, appId and namespace fields are mandatory.");
            }
            this.image.url = UtilsFactory.getResourceUtils().createUrl(this.appId, this.namespace, this.image.getFileName(), this.portal);
            return this.image;
        }
    }

    public static class Builder {
        private Image image = new Image();

        private Builder() {
        }

        public Builder fileName(String fileName) {
            this.image.fileName = fileName;
            return this;
        }

        public Builder originalName(String originalName) {
            this.image.originalName = originalName;
            return this;
        }

        public URLBuilder prepareUrl() {
            return new URLBuilder(this.image);
        }
    }
}

