/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.instance.provider;

public class InstanceProviderRequest<T> {
    private T obj;

    private InstanceProviderRequest(T obj) {
        this.obj = obj;
    }

    public T get() {
        return this.obj;
    }

    public static DesignMyAppRequest designMyApp() {
        return new DesignMyAppRequest();
    }

    public static class DesignMyAppRequest {
        private String keyId;
        private String secretKey;
        private String hostname;
        private int poolSize;
        private int ttl;

        private DesignMyAppRequest() {
        }

        public DesignMyAppRequest hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public DesignMyAppRequest keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public DesignMyAppRequest secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public DesignMyAppRequest poolSize(int poolSize) {
            if (poolSize <= 0) {
                throw new IllegalArgumentException("PoolSize Cannot be less than or equal to 0.");
            }
            this.poolSize = poolSize;
            return this;
        }

        public DesignMyAppRequest ttl(int ttl) {
            if (ttl < 0) {
                throw new IllegalArgumentException("TTL Cannot be negative.");
            }
            this.ttl = ttl;
            return this;
        }

        public InstanceProviderRequest<DesignMyAppRequest> build() {
            if (this.hostname == null || this.keyId == null || this.secretKey == null || this.poolSize <= 0) {
                throw new IllegalArgumentException("None of these parameters should be null : hostname, keyId, secretKey, and poolSize must be strictly superior to 0");
            }
            return new InstanceProviderRequest<DesignMyAppRequest>(this);
        }

        public String getKeyId() {
            return this.keyId;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPoolSize() {
            return this.poolSize;
        }

        public int getTtl() {
            return this.ttl;
        }
    }
}

