/*
Copyright © 2014 by eBusiness Information
All rights reserved. This source code or any portion thereof
may not be reproduced or used in any manner whatsoever
without the express written permission of eBusiness Information.
*/
package mobi.designmyapp.common.utils;


import mobi.designmyapp.common.model.Price;

public class PriceUtils {

  public static Price create(String number) {
    return round(new Price(number));
  }

  public static Price round(Price Price) {
    return new Price(Price.setScale(2, Price.ROUND_HALF_DOWN));
  }

  public static boolean isZero(Price Price) {
    return eq(Price, create("0"));
  }

  public static boolean eq(Price price, Price Price) {
    return price.compareTo(Price) == 0;
  }

  public static boolean isNegative(Price Price) {
    return Price.compareTo(create("0")) < 0;
  }
}
