/*
Copyright © 2014 by eBusiness Information
All rights reserved. This source code or any portion thereof
may not be reproduced or used in any manner whatsoever
without the express written permission of eBusiness Information.
*/
package mobi.designmyapp.common.utils;

import mobi.designmyapp.common.service.PricingService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * Created by Loïc Ortola on 7/24/14.
 */
public class PricingUtils implements ApplicationContextAware {

  private static ApplicationContext ctx;
  private static PricingService pricingService;

  public static PricingService getPricingService() {
    if(pricingService == null) {
      pricingService = (PricingService) ctx.getBean("pricingServiceImpl");
    }
    return pricingService;
  }

  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    ctx = applicationContext;
  }
}
