/*
Copyright © 2014 by eBusiness Information
All rights reserved. This source code or any portion thereof
may not be reproduced or used in any manner whatsoever
without the express written permission of eBusiness Information.
*/
package mobi.designmyapp.common.utils;

import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;

/**
 * Created by Loïc Ortola on 7/25/14.
 */
public class StorageUtils {

  public static final String OS = System.getProperty("os.name").toLowerCase();

  /**
   * Copy all files in sourceDir to destDir.
   */
  public static void copyDirectoryContent(File sourceDir, File destDir) {
    try {
      FileUtils.copyDirectory(sourceDir, destDir);
    } catch (IOException e) {
      throw new IllegalStateException("Unable to copy directory:"+e);
    }
  }

  public static File locateFile(File sourceDir, String fileRelativePath) {
    final File file = new File(sourceDir.getAbsolutePath() + "/" + fileRelativePath);
    if (!file.exists())
      throw new IllegalArgumentException("File " + file.getAbsolutePath() + " doesn't exist.");
    return file;
  }

  public static boolean isWindows() {
    return (OS.indexOf("win") >= 0);
  }

  public static boolean isMac() {
    return (OS.indexOf("mac") >= 0);
  }
}
