package mobi.designmyapp.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.math.BigInteger;
import java.security.SecureRandom;

public final class Utils {
  private static final Logger logger = LoggerFactory.getLogger(Utils.class);
  public static final String OS = System.getProperty("os.name").toLowerCase();
  private static final SecureRandom random = new SecureRandom();


  private Utils() {
    // Prevents instantiation
  }

//----------------------------------------------------------------------------------------

  public static String generateKey() {
    return new BigInteger(130, random).toString(32);
  }



  public static InputStream openClassPathResource(String path) {
    return Utils.class.getResourceAsStream(path);
  }


  /**
   * Escapes single and double quotes
   */
  public static String escapeQuotes(String s) {
    String strippedSlashes = StringUtils.replaceEach(s, new String[]{"\\\\'", "\\\\\"", "\\'", "\\\""}, new String[]{"'", "\"", "'", "\""});
    return StringUtils.replaceEach(strippedSlashes, new String[]{"'", "\""}, new String[]{"\\'", "\\\""});
  }

}
