/*
Copyright © 2014 by eBusiness Information
All rights reserved. This source code or any portion thereof
may not be reproduced or used in any manner whatsoever
without the express written permission of eBusiness Information.
*/
package mobi.designmyapp.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * Created by Loïc Ortola on 7/23/14.
 */
public class ZipUtils {

  private static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);

  /**
   * Extract Zip file in temp folder to prepare all sources
   */
  public static void unzip(File zipFile, List<String> validExtensions, List<String> errorFiles) throws IOException {
    logger.debug("Entering unzip");
    byte[] buffer = new byte[1024];

    ZipInputStream zip = new ZipInputStream(new FileInputStream(zipFile));
    String extRegex = null;
    if(validExtensions != null && !validExtensions.isEmpty())
      extRegex = FileManagementUtils.stringListBuilder(validExtensions, "(", "|", ")$");

    boolean validFile = false;


    ZipEntry ze = null;

    File zipExtractDirectory = new File(zipFile.getParentFile(),FileManagementUtils.getNameWithoutExtension(zipFile.getName()));

    while ((ze = zip.getNextEntry()) != null) {

      String fileName = ze.getName();
      String fExtension = fileName.substring(fileName.lastIndexOf(".") + 1);

      // If file is not at the root of the zip file, retrieve its fileName
      if ((fileName.lastIndexOf("/")) != -1) {
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
      }

      File newFile = new File(zipExtractDirectory, ze.getName());

      logger.debug("Extracting " + newFile.getAbsolutePath());

      if (ze.isDirectory()) {
        logger.debug("Mkdir to " + newFile.getAbsolutePath());
        newFile.mkdirs();
      } else {
        logger.debug("Checking the validity of the folder (must contains at least one file with extension including in regex");
        validFile = FileManagementUtils.isValidFileName(FileManagementUtils.getNameWithoutExtension(fileName)) && fExtension.matches(extRegex);

        if (!validFile) {
          errorFiles.add(fileName);
        } else {
          logger.debug("Writing only valid files to " + newFile.getAbsolutePath());
          new File(newFile.getParent()).mkdirs();
          FileOutputStream fos = new FileOutputStream(newFile);
          int len;
          while ((len = zip.read(buffer)) > 0) {
            fos.write(buffer, 0, len);
          }
          fos.close();
        }
      }
    }
    logger.debug("Leaving unzip");
  }


}
