/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.utils;

import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ResampleOp;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import mobi.designmyapp.common.model.Density;
import mobi.designmyapp.common.utils.ImageUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileManagementUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileManagementUtils.class);
    public static final String OS = System.getProperty("os.name").toLowerCase();
    private static final String DIGIT_REGEX = "^[0-9]+$";
    private static final String IMAGE_URL_REGEX = "^(http\\:\\/\\/[a-zA-Z0-9\\-\\.]+\\.[a-zA-Z]{2,3}(?:\\/\\S*)?(?:[a-zA-Z0-9_])+\\.(?:jpg|jpeg|gif|png))$";
    private static final String PATH_REGEX = "^(\\$\\..*)";
    private static final String EMAIL_REGEX = "^(([^<>()\\[\\]\\.,;:\\s@\\\"]+(\\.[^<>()\\[\\]\\.,;:\\s@\\\"]+)*)|(\\\".+\\\"))@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
    private static final String PHONE_NUMBER_REGEX = "^\\+?[0-9\\. ]+$";
    private static final int MAX_ANDROID_DENSITY_RATIO = 4;
    private static final int DEFAULT_ANDROID_ICON_SIZE = 192;
    private static final Density[] ANDROID_DENSITIES = new Density[]{new Density("ldpi", 0.75f), new Density("mdpi", 1.0f), new Density("hdpi", 1.5f), new Density("xhdpi", 2.0f), new Density("xxhdpi", 3.0f)};
    private static final int DEFAULT_IOS_ICON_SIZE = 152;
    private static final Density[] IOS_DENSITIES = new Density[]{new Density("-40", 0.5263158f), new Density("-50", 0.65789473f), new Density("-60", 0.7894737f), new Density("-72", 0.94736844f), new Density("-76", 1.0f), new Density("-small", 0.38157895f), new Density("", 0.75f)};

    private FileManagementUtils() {
    }

    public static String generateKey() {
        return UUID.randomUUID().toString();
    }

    public static void copyFile(File srcFile, File destFile) {
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to copy file.", e);
        }
    }

    public static void copyFileToDirectory(File srcFile, File destDir) {
        try {
            FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyDirectoryContent(File sourceDir, File destDir) {
        try {
            FileUtils.copyDirectory((File)sourceDir, (File)destDir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to copy directory.", e);
        }
    }

    public static String escapeQuotes(String s) {
        String strippedSlashes = StringUtils.replaceEach((String)s, (String[])new String[]{"\\\\'", "\\\\\"", "\\'", "\\\""}, (String[])new String[]{"'", "\"", "'", "\""});
        return StringUtils.replaceEach((String)strippedSlashes, (String[])new String[]{"'", "\""}, (String[])new String[]{"\\'", "\\\""});
    }

    public static void replaceTokens(Object model, File srcDirectory, List<String> parseList, File destDirectory) {
        Configuration configuration = new Configuration();
        configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
        try {
            for (String filePathToBeParsed : parseList) {
                File fileOutput = FileManagementUtils.locateFile(destDirectory, filePathToBeParsed);
                OutputStreamWriter output = new OutputStreamWriter(new FileOutputStream(fileOutput));
                configuration.setDirectoryForTemplateLoading(srcDirectory);
                Template template = configuration.getTemplate(filePathToBeParsed);
                template.process(model, (Writer)output);
                if (output == null) continue;
                ((Writer)output).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void parseAndCopyAll(Configuration configuration, Object model, File sourceDirectory, List<String> filesToBeParsedRelativePath, File targetDirectory) {
        try {
            for (String filePathToBeParsed : filesToBeParsedRelativePath) {
                File fileOutput = new File(targetDirectory, filePathToBeParsed);
                if (fileOutput.exists()) {
                    OutputStreamWriter output = new OutputStreamWriter(new FileOutputStream(fileOutput));
                    configuration.setDirectoryForTemplateLoading(sourceDirectory);
                    Template template = configuration.getTemplate(filePathToBeParsed);
                    template.process(model, (Writer)output);
                    if (output == null) continue;
                    ((Writer)output).close();
                    continue;
                }
                LOGGER.warn("File {} doesn't exist. Not parsing this file", (Object)fileOutput.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public static File locateFile(File sourceDir, String fileRelativePath) {
        File file = new File(sourceDir.getAbsolutePath() + "/" + fileRelativePath);
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " doesn't exist.");
        }
        return file;
    }

    private static String normalizeForFileName(String value) {
        if ((value = value.replaceAll("\\W", "_")).length() > 80) {
            value = value.substring(0, 80);
        }
        return value;
    }

    public static String computePackage(String appName, String applicationPackage, String templateTag) {
        return applicationPackage + "." + templateTag + "." + FileManagementUtils.normalizeForFileName(appName).toLowerCase();
    }

    public static void copyDataFromTmpToWork(File tmp, File work) {
        File workAssetsDir = FileManagementUtils.getDataDir(work);
        if (tmp.exists()) {
            FileManagementUtils.copyDirectoryContent(tmp, workAssetsDir);
        }
    }

    public static void copySourceFromTmpToWork(File tmp, File work) {
        File workAssetsDir = FileManagementUtils.getSourceDir(work);
        if (tmp.exists()) {
            FileManagementUtils.copyDirectoryContent(tmp, workAssetsDir);
        }
    }

    private static File getDataDir(File parent) {
        File dataDir = new File(parent, "build/apk/assets/data");
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        return dataDir;
    }

    private static File getSourceDir(File parent) {
        File dataDir = new File(parent, "build/apk/assets/sources");
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        return dataDir;
    }

    public static void assertCanRead(String dir) {
        if (!new File(dir).canRead()) {
            throw new IllegalStateException(dir + " should be readable.");
        }
    }

    public static void assertCanWrite(String dir) {
        if (!new File(dir).canWrite()) {
            throw new IllegalStateException(dir + " should be readable.");
        }
    }

    public static String getExtension(String name) {
        String[] fileNameParts = name.split("\\.");
        String lastPart = fileNameParts[fileNameParts.length - 1];
        return "." + lastPart;
    }

    public static String getNameWithoutExtension(String name) {
        String[] fileNameParts = name.split("\\.");
        String firstPart = fileNameParts[0];
        return firstPart;
    }

    public static void copyAndroidDrawablesFromTmpToWork(File tmpDirectory, File workDirectory) {
        for (int i = 0; i < ANDROID_DENSITIES.length; ++i) {
            Density density = ANDROID_DENSITIES[i];
            File drawable_tmp = new File(tmpDirectory.getAbsolutePath() + File.separator + "image/drawable-" + density.getDensity());
            File drawable_work = new File(workDirectory.getAbsolutePath() + "/res/");
            if (!drawable_tmp.exists()) continue;
            try {
                FileUtils.copyDirectoryToDirectory((File)drawable_tmp, (File)drawable_work);
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Error copying drawable directory", (Throwable)e);
                return;
            }
        }
    }

    public static void moveImagesFromTmpToAssetsPictures(String tmpPath, String workPath) {
        try {
            for (File file : new File(tmpPath + File.separator + "image").listFiles()) {
                if (!file.isFile()) continue;
                FileUtils.copyFileToDirectory((File)file, (File)new File(workPath + "/assets/pictures"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void cleanDirectory(File directory) {
        try {
            FileUtils.cleanDirectory((File)directory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file);
    }

    public static void copyInputStreamToFile(InputStream inputStream, File file) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteFile(File file) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void moveFile(File srcFile, File destFile) {
        try {
            FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getSizeForDensity(int originalSize, float densityFactor) {
        return (int)((float)originalSize * densityFactor / 4.0f);
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int maxWidth, int maxHeight) {
        DimensionConstrain dimenConstrain = DimensionConstrain.createMaxDimension((int)maxWidth, (int)maxHeight, (boolean)true);
        ResampleOp resampleOp = new ResampleOp(dimenConstrain);
        return resampleOp.filter(originalImage, null);
    }

    public static void writeBufferedImageToFile(BufferedImage image, File file) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createImageReference(String imageName, int drawableId, File tempDirectory) {
        String referenceLine = "<public type=\"drawable\" name=\"" + FilenameUtils.removeExtension((String)ImageUtils.normalizeImageName(imageName)) + "\" id=\"0x" + Integer.toHexString(drawableId) + "\" />";
        File referencesFile = new File(tempDirectory, "/res/values/public.xml");
        try {
            List lines = FileUtils.readLines((File)referencesFile);
            lines.add(lines.size() - 1, referenceLine);
            FileUtils.writeLines((File)referencesFile, (String)"UTF-8", (Collection)lines);
        }
        catch (IOException e) {
            LOGGER.error("Error creating drawable", (Throwable)e);
        }
    }

    public static long minToMillis(long minutes) {
        return 60000L * minutes;
    }

    public static boolean isImageUrl(String value) {
        if (value == null) {
            return false;
        }
        return Pattern.compile(IMAGE_URL_REGEX).matcher(value).matches();
    }

    public static boolean isJsonPath(String value) {
        if (value == null) {
            return false;
        }
        return Pattern.compile(PATH_REGEX).matcher(value).matches();
    }

    public static String parsePath(String pathToTest) {
        while (pathToTest.startsWith("/")) {
            pathToTest = pathToTest.substring(1);
        }
        pathToTest = pathToTest.replaceAll("\\.\\.", "");
        while (pathToTest.endsWith("/")) {
            pathToTest = pathToTest.substring(0, pathToTest.length() - 1);
        }
        return pathToTest;
    }

    public static boolean isValidFileName(String fileName) {
        String valid = "[\\p{Alnum}\\s_-]+";
        return fileName.matches(valid);
    }

    public static void eraseAndCopyDir(File sourceDir, File destDir) {
        if (destDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)destDir);
            }
            catch (IOException e) {
                boolean success = FileUtils.deleteQuietly((File)destDir);
                LOGGER.debug("FileUtils.cleanDirectory failed; deleting file: " + success);
            }
        }
        if (sourceDir.exists()) {
            try {
                FileUtils.copyDirectory((File)sourceDir, (File)destDir);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to copy directory.");
            }
        }
    }

    public static boolean isEmail(String value) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Pattern.compile(EMAIL_REGEX).matcher(value).matches();
    }

    public static boolean isValidPhoneNumber(String value) {
        if (value == null || value.trim().isEmpty()) {
            return true;
        }
        return Pattern.compile(PHONE_NUMBER_REGEX).matcher(value).matches();
    }

    public static boolean noHtmlText(String value) {
        if (value == null) {
            return true;
        }
        if (value.contains("<") || value.contains(">") || value.contains("=") || value.matches(".*\\\".*")) {
            return false;
        }
        return !value.contains("&gt") && !value.contains("&lt") && !value.contains("&quot");
    }

    public static String stringListBuilder(List<String> items, String start, String separator, String end) {
        StringBuilder sb = new StringBuilder();
        if (items == null) {
            return sb.append(start).append(end).toString();
        }
        if (items.size() == 1) {
            return sb.append(start).append(items.get(0)).append(end).toString();
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = items.get(i);
            if (i == 0) {
                sb.append(start);
            }
            sb.append(item);
            if (i < size - 1) {
                sb.append(separator);
                continue;
            }
            sb.append(end);
        }
        return sb.toString();
    }

    public static String createHash(File f) {
        try {
            return DigestUtils.shaHex((InputStream)new FileInputStream(f));
        }
        catch (IOException e) {
            throw new IllegalStateException("File not found:" + f.getAbsolutePath());
        }
    }
}

