/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.utils;

import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import mobi.designmyapp.common.model.Density;
import mobi.designmyapp.common.model.DensityPx;
import mobi.designmyapp.common.utils.FileManagementUtils;

public class ImageUtils {
    private static final int MAX_ANDROID_DENSITY_RATIO = 4;
    private static final int DEFAULT_ANDROID_ICON_SIZE = 192;
    private static final Density[] ANDROID_DENSITIES = new Density[]{new Density("ldpi", 0.75f), new Density("mdpi", 1.0f), new Density("hdpi", 1.5f), new Density("xhdpi", 2.0f), new Density("xxhdpi", 3.0f)};
    private static final int DEFAULT_IOS_ICON_SIZE = 152;
    private static final Density[] IOS_DENSITIES = new Density[]{new Density("-40", 0.5263158f), new Density("-50", 0.65789473f), new Density("-57", 0.75f), new Density("-60", 0.7894737f), new Density("-72", 0.94736844f), new Density("-76", 1.0f), new Density("-small", 0.38157895f), new Density("", 0.75f)};
    private static final DensityPx[] IOS_SPLASH_DENSITIES = new DensityPx[]{new DensityPx("-568h@2x", 640, 1136), new DensityPx("-Portrait-667h@2x", 750, 1334), new DensityPx("-Portrait-736@3x", 1242, 2208), new DensityPx("-Portrait~iPad", 768, 1004), new DensityPx("-Portrait", 768, 1024), new DensityPx("-Portrait@2x", 1536, 2048), new DensityPx("-iPad", 768, 1004), new DensityPx("", 320, 480), new DensityPx("@2x", 640, 960)};

    public static void resizeImageToIcon(InputStream stream, File destFile) {
        try {
            BufferedImage originalImage = ImageIO.read(stream);
            BufferedImage resizedImage = ImageUtils.resizeImage(originalImage, 192, 192);
            ImageUtils.writeBufferedImageToFile(resizedImage, destFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveAndroidIcons(File icon, File directory, String iconName) {
        try {
            BufferedImage originalImage = ImageIO.read(icon);
            for (int i = 0; i < ANDROID_DENSITIES.length; ++i) {
                Density density = ANDROID_DENSITIES[i];
                int maxWidth = ImageUtils.getSizeForDensity(192, density.getFactor());
                int maxHeight = ImageUtils.getSizeForDensity(192, density.getFactor());
                BufferedImage resizedImage = ImageUtils.resizeImage(originalImage, maxWidth, maxHeight);
                File drawableDirectory = new File(directory, "drawable-" + density.getDensity());
                drawableDirectory.mkdirs();
                File resizedImageFile = new File(drawableDirectory, iconName);
                ImageUtils.writeBufferedImageToFile(resizedImage, resizedImageFile);
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveIosIcons(File icon, File directory, String iconName) {
        try {
            BufferedImage originalImage = ImageIO.read(icon);
            String iconNameWithoutExtension = FileManagementUtils.getNameWithoutExtension(iconName);
            for (int i = 0; i < IOS_DENSITIES.length; ++i) {
                Density density = IOS_DENSITIES[i];
                int maxWidth = (int)(152.0f * density.getFactor());
                int maxHeight = (int)(152.0f * density.getFactor());
                BufferedImage resizedImage = ImageUtils.resizeImage(originalImage, maxWidth / 2, maxHeight / 2);
                BufferedImage resizedImage2x = ImageUtils.resizeImage(originalImage, maxWidth, maxHeight);
                File resizedImageFile = new File(directory, iconNameWithoutExtension + density.getDensity() + ".png");
                ImageUtils.writeBufferedImageToFile(resizedImage, resizedImageFile);
                File resizedImageFile2x = new File(directory, iconNameWithoutExtension + density.getDensity() + "@2x.png");
                ImageUtils.writeBufferedImageToFile(resizedImage2x, resizedImageFile2x);
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveIosSplashScreens(File ss, File directory) {
        try {
            BufferedImage originalImage = ImageIO.read(ss);
            String splashscreenName = "Default";
            for (int i = 0; i < IOS_SPLASH_DENSITIES.length; ++i) {
                DensityPx density = IOS_SPLASH_DENSITIES[i];
                int maxWidth = density.getWidth();
                int maxHeight = density.getHeight();
                BufferedImage resizedImage = ImageUtils.cropImage(originalImage, maxWidth, maxHeight);
                File resizedImageFile = new File(directory, splashscreenName + density.getDensity() + ".png");
                ImageUtils.writeBufferedImageToFile(resizedImage, resizedImageFile);
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getSizeForDensity(int originalMaxSize, float densityFactor) {
        return (int)((float)originalMaxSize * densityFactor / 4.0f);
    }

    public static String normalizeImageName(String value) {
        value = value.toLowerCase();
        value = value.replaceAll("[^a-z0-9._]", "_");
        String[] parts = value.split("\\.");
        StringBuilder concat = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length - 1; ++i) {
            concat.append("_" + parts[i]);
        }
        concat.append("." + parts[parts.length - 1]);
        return concat.toString();
    }

    @Deprecated
    public static void resizeImageForAllAndroidDensities(String imageName, File imageFile, File tmpDirectory, boolean force) {
        ImageUtils.resizeImageForAllAndroidDensities(imageName, imageFile, tmpDirectory);
    }

    public static void resizeImageForAllAndroidDensities(String imageName, File imageFile, File tmpDirectory) {
        try {
            BufferedImage originalImage = ImageIO.read(new FileInputStream(imageFile));
            int originalWidth = originalImage.getWidth();
            int originalHeight = originalImage.getHeight();
            for (int i = 0; i < ANDROID_DENSITIES.length; ++i) {
                Density density = ANDROID_DENSITIES[i];
                int maxWidth = ImageUtils.getSizeForDensity(originalWidth, density.getFactor());
                int maxHeight = ImageUtils.getSizeForDensity(originalHeight, density.getFactor());
                BufferedImage resizedImage = ImageUtils.resizeImage(originalImage, maxWidth, maxHeight);
                ImageUtils.saveImageInFolder(imageName, tmpDirectory, density, resizedImage);
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveImageInFolder(String imageName, File tempDirectory, Density density, BufferedImage resizedImage) {
        File drawable = new File(tempDirectory, "drawable-" + density.getDensity());
        if (!drawable.exists()) {
            drawable.mkdir();
        }
        File resizedImageFile = new File(drawable, ImageUtils.normalizeImageName(imageName));
        ImageUtils.writeBufferedImageToFile(resizedImage, resizedImageFile);
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int maxWidth, int maxHeight) {
        DimensionConstrain dimenConstrain = DimensionConstrain.createMaxDimension((int)maxWidth, (int)maxHeight, (boolean)true);
        ResampleOp resampleOp = new ResampleOp(dimenConstrain);
        return resampleOp.filter(originalImage, null);
    }

    public static BufferedImage cropImage(BufferedImage originalImage, int width, int height) {
        DimensionConstrain dimenConstrain = DimensionConstrain.createAbsolutionDimension((int)width, (int)height);
        ResampleOp resampleOp = new ResampleOp(dimenConstrain);
        return resampleOp.filter(originalImage, null);
    }

    public static BufferedImage resizeImageSquare(BufferedImage originalImage, int size) {
        DimensionConstrain dimenConstrain = DimensionConstrain.createAbsolutionDimension((int)size, (int)size);
        ResampleOp resampleOp = new ResampleOp(dimenConstrain);
        return resampleOp.filter(originalImage, null);
    }

    public static BufferedImage resizeImageSquare(File originalImageFile, int size) {
        try {
            return ImageUtils.resizeImageSquare(ImageIO.read(originalImageFile), size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage resizeImage(File originalImageFile, int maxWidth, int maxHeight) {
        try {
            return ImageUtils.resizeImage(ImageIO.read(originalImageFile), maxWidth, maxHeight);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void convertToPng(File srcFile, File dstFile) {
        try {
            ImageUtils.writeBufferedImageToFile(ImageIO.read(srcFile), dstFile);
            FileManagementUtils.deleteFile(srcFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBufferedImageToFile(BufferedImage image, File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

