/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import mobi.designmyapp.common.builder.Builder;
import mobi.designmyapp.common.service.ResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ResourceUtils
implements ApplicationContextAware {
    private static ResourceService resourceService;
    private static ApplicationContext ctx;
    private static final Logger logger;

    private static void loadService() {
        if (resourceService == null) {
            resourceService = (ResourceService)ctx.getBean("resourceServiceImpl");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ctx = applicationContext;
    }

    public static File getResourceDirectory(String appId) {
        ResourceUtils.loadService();
        return resourceService.getResourceDirectory(appId);
    }

    public static File getResourceDirectory(String appId, String nameSpace) {
        ResourceUtils.loadService();
        return new File(resourceService.getResourceDirectory(appId), nameSpace);
    }

    public static File getWorkDirectory(Builder.Type type, String appId) {
        ResourceUtils.loadService();
        return resourceService.getWorkDirectory(type, appId);
    }

    public static File getTmpDirectory(String appId) {
        ResourceUtils.loadService();
        return resourceService.getTmpDirectory(appId);
    }

    public static File getTemplateDirectory(Builder.Type type, String templateTag) {
        ResourceUtils.loadService();
        return resourceService.getTemplateDirectory(type, templateTag);
    }

    public static File getStaticResourcesDirectory(String templateTag) {
        return resourceService.getStaticResourcesDirectory(templateTag);
    }

    public static String createUrl(String appId, String namespace, String filename, String portalName) {
        ResourceUtils.loadService();
        StringBuilder result = new StringBuilder();
        result.append(resourceService.getEnvironmentBaseUrl());
        result.append("/1.0/file/");
        result.append(appId);
        result.append("/");
        result.append(namespace);
        result.append("/");
        result.append(filename);
        if (portalName != null) {
            result.append("?portal=");
            result.append(portalName);
        }
        return result.toString();
    }

    public static boolean serializeObjectToFile(File destFile, Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue(destFile, obj);
            return true;
        }
        catch (IOException e) {
            logger.error("Error while serializing object to file:", (Throwable)e);
            return false;
        }
    }

    static {
        logger = LoggerFactory.getLogger(ResourceUtils.class);
    }
}

