/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class StorageUtils {
    public static final String OS = System.getProperty("os.name").toLowerCase();

    public static void copyDirectoryContent(File sourceDir, File destDir) {
        try {
            FileUtils.copyDirectory((File)sourceDir, (File)destDir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to copy directory:" + e);
        }
    }

    public static File locateFile(File sourceDir, String fileRelativePath) {
        File file = new File(sourceDir.getAbsolutePath() + "/" + fileRelativePath);
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " doesn't exist.");
        }
        return file;
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }
}

